% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_domains}
\alias{summarize_domains}
\title{Create domain-level summary of simulation results}
\usage{
summarize_domains(simulation_results, domain_variable = "domain_id")
}
\arguments{
\item{simulation_results}{Simulation results dataframe.}

\item{domain_variable}{Variable by which individual simulations should be grouped.}
}
\value{
Simulation results summarized across domains.
}
\description{
Given a dataframe of raw results from \code{\link{run_simulations}}, summarize
the individual results at a per-domain level. This domain-level summary
is a useful data structure for aggregate reporting.
}
\details{
Summary stats created include:
\itemize{
\item Mean/Min/Max/Median are calculated for loss events
\item Median/Max/VaR are calculated for annual loss expected (ALE)
\item Mean/Median/Max/Min are calculated for single loss expected (SLE)
\item Mean percentage of threat capability exceeding difficulty on successful threat events
\item Mean percentage of difficulty exceeding threat capability on defended events
\item Vulnerability percentage
}
}
\examples{
\dontrun{
data(mc_simulation_results)
summarize_domains(mc_simulation_results)
}
}
