% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openfair.R
\name{select_loss_opportunities}
\alias{select_loss_opportunities}
\title{Determine which threat events result in loss opportunities}
\usage{
select_loss_opportunities(tc, diff, n = NULL, ...)
}
\arguments{
\item{tc}{Threat capability (as a percentage).}

\item{diff}{Difficulty (as a percentage).}

\item{n}{Number of samples to generate.}

\item{...}{Optional parameters (currently ignored).}
}
\value{
List containing boolean values of length TC (as a vector) and details (as a list).
}
\description{
Composition function for use in \code{\link{sample_vuln}}, does a simple
compare of all threat events where the threat capability (TC) is greater
than the difficulty (DIFF).
}
\examples{
threat_capabilities <- c(.1, .5, .9)
difficulties <- c(.09, .6, .8)
select_loss_opportunities(threat_capabilities, difficulties)
}
\seealso{
Other OpenFAIR helpers: \code{\link{compare_tef_vuln}},
  \code{\link{get_mean_control_strength}},
  \code{\link{openfair_tef_tc_diff_lm}},
  \code{\link{sample_diff}}, \code{\link{sample_lef}},
  \code{\link{sample_lm}}, \code{\link{sample_tc}},
  \code{\link{sample_vuln}}
}
\concept{OpenFAIR helpers}
