% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_lablinks.r
\name{epmc_lablinks}
\alias{epmc_lablinks}
\title{Get links to external sources}
\usage{
epmc_lablinks(
  ext_id = NULL,
  data_src = "med",
  lab_id = NULL,
  limit = 100,
  verbose = TRUE
)
}
\arguments{
\item{ext_id}{publication identifier}

\item{data_src}{data source, by default Pubmed/MedLine index will be searched.
The following three letter codes represents the sources
Europe PubMed Central supports:
\describe{
  \item{agr}{Agricola is a bibliographic database of citations to the
  agricultural literature created by the US National Agricultural Library
  and its co-operators.}
  \item{cba}{Chinese Biological Abstracts}
  \item{ctx}{CiteXplore}
  \item{eth}{EthOs Theses, i.e. PhD theses (British Library)}
  \item{hir}{NHS Evidence}
  \item{med}{PubMed/Medline NLM}
  \item{nbk}{Europe PMC Book metadata}
  \item{pat}{Biological Patents}
  \item{pmc}{PubMed Central}
  }}

\item{lab_id}{character vector, identifiers of the external link service.
Use Europe PMC's advanced search form to find ids.}

\item{limit}{Number of records to be returned. By default, this function
returns 100 records.}

\item{verbose}{print information about what's going on}
}
\value{
Links found as nested data_frame
}
\description{
With the External Link services, Europe PMC allows third parties to publish
links from Europe PMC to other webpages or tools. Current External Link
providers, which can be selected through Europe PMC's advanced search,
include Wikipedia, Dryad Digital Repository or other open services.
For more information, see
\url{https://europepmc.org/labslink}.
}
\examples{
  \dontrun{
  # Fetch links
  epmc_lablinks("24007304")
  # Link to Altmetric (lab_id = "1562")
  epmc_lablinks("25389392", lab_id = "1562")

  # Links to Wikipedia
  epmc_lablinks("24007304", lab_id = "1507")

  # Link to full text copy archived through the institutional repo of
  Bielefeld University
  epmc_lablinks("12736239", lab_id = "1056")
  }
}
