% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_non_standard_calendar.R
\name{map_non_standard_calendar}
\alias{map_non_standard_calendar}
\title{Create map indices from non-standard calendars}
\usage{
map_non_standard_calendar(times)
}
\arguments{
\item{times}{Vector of class PCICt (will be truncated to days).}
}
\value{
A \code{\link[data.table]{data.table}} with columns:

  \itemize{ \item dates_full: sequence of standard dates from min to max date
  in input times as data.table::IDate \item dates_pcict_inter: which dates in
  PCICt from times correspond to the standard dates \item idx_pcict: the
  index associated to the input times to be used for mapping e.g. values }
}
\description{
Interpolates non-standard calendars (360 and noleap) to the standard
Gregorian. Assumes daily data as input.
}
\examples{
# example data from EURO-CORDEX (cropped for size)
# non-standard calendar (360)
fn2 <- system.file("extdata", "test2.nc", package = "eurocordexr")
ncobj <- ncdf4::nc_open(fn2)

# read as PCICt-class
times <- ncdf4.helpers::nc.get.time.series(ncobj, "tasmin")
str(times)

dtx <- map_non_standard_calendar(times)
dtx[58:64]

}
\seealso{
Can be used internally in \code{\link{rotpole_nc_point_to_dt}} and
  \code{\link{nc_grid_to_dt}} by setting the respective arguments.
}
