% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tafel.R
\name{et_tafel}
\alias{et_tafel}
\title{Ertragstafelwerte einer Baumart}
\usage{
et_tafel(
  art,
  alter = NULL,
  bon = NULL,
  bon_typ = "relativ",
  methode = "klassisch"
)
}
\arguments{
\item{art}{Baumartenbezeichnung entweder als Kürzel, deutscher Name,
lateinischer Name oder in niedersächsischer Kodierung.
Für vorhandene Arten siehe \code{\link[=et_liste]{et_liste()}}.}

\item{alter}{Bestandesalter in Jahren als ganze Zahl (optional). Zwischen 5
und max. zulässigem Alter (Ei 220, Bu 180 und Fi, Dgl, Ki 160).}

\item{bon}{Ertragsklasse als Zahl (optional). Bei Methode \code{"klassisch"} im
Interval [-2,4].}

\item{bon_typ}{Die Bonität kann als relative Ertragsklasse (\code{"relativ"}) oder
absolute Oberhöhenbonität (H100 im Alter 100, \code{"absolut"}) angegeben werden.
Parameter kann gekürzt werden, solange er eindeutig bleibt.}

\item{methode}{Derzeit wird nur die Inter-/Extrapolation der Ertragstafel
mittels Dreisatz (\code{"klassisch"}) angeboten. Parameter kann gekürzt werden,
solange er eindeutig bleibt.}
}
\value{
Ein Dataframe mit den Spalten \code{Ekl}, \code{Alter},
\code{N}, \code{Hg}, \code{H100}, \code{G}, \code{Dg}, \code{Dw}, \code{V}, \code{N_aus}, \code{G_aus}, \code{Dg_aus},
\code{V_aus}, \code{iV}, \code{GWL}, \code{dGZ}.

\tabular{ll}{
\strong{Kürzel} \tab \strong{Beschreibung}\cr
\code{Ekl}    \tab relative Ertragsklasse [-]\cr
\code{Alter}  \tab Bestandesalter [a]\cr
\code{N}      \tab Stammzahl (verbleibend) [Stk/ha]\cr
\code{Hg}     \tab Mittelhöhe (verbleibend) [m]\cr
\code{H100}   \tab Oberhöhe (verbleibend) [m]\cr
\code{G}      \tab Grundfläche (verbleibend) [m^2/ha] \cr
\code{Dg}     \tab mittlerer BHD (verbleibend) [cm]\cr
\code{Dw}     \tab mittlerer Durchmesser nach Weise (verbleibend) [cm]\cr
\code{V}      \tab Vorrat (verbleibend) [m^3/ha]\cr
\code{N_aus}  \tab Stammzahl (ausscheidend) [Stk/ha]\cr
\code{G_aus}  \tab Grundfläche (ausscheidend) [m^2/ha]\cr
\code{Dg_aus} \tab mittlerer Durchmesser (ausscheidend) [cm]\cr
\code{V_aus}  \tab Vorrat (ausscheidend) [m^3/ha]\cr
\code{iV}     \tab laufender Volumenzuwachs [m^3/ha/a]\cr
\code{GWL}    \tab Gesamtwuchsleistung [m^3/ha]\cr
\code{dGZ}    \tab durchschnittlicher Gesamtzuwachs [m^3/ha/a]
}

Wenn durch die klassische Interpolation mittels Dreisatz negative Werte
entstehen sollten, werden die jeweiligen Werte auf \code{NA} (N, Hg, H100, Dg, Dw)
oder \code{0} (G, V, N_aus, G_aus, Dg_aus, V_aus, iV, GWL, dGZ) gesetzt.
}
\description{
Gibt die vollständige Ertragstafel einer Baumart aus oder ermittelt die
Ertragstafelwerte für gegebene Alter und/oder Bonitäten. Wenn Letztere von
den in der Ertragstafel (Albert et al. 2021)  enthaltenen Werten abweichen,
werden die Variablen der Tafel auf die gewünschten Alter und/oder Bonitäten
inter-/extrapoliert. Derzeit ist nur die klassische Variante mittels Dreisatz
implementiert.
}
\details{
Bei der klassischen linearen Extrapolation in den Bereich sehr junger
Bestandesalter können negative Werte entstehen. Die jeweiligen Werte werden
dann auf \code{NA} (N, Hg, H100, Dg, Dw) oder \code{0} (G, V, N_aus, G_aus, Dg_aus,
V_aus, iV, GWL, dGZ) gesetzt.
}
\examples{
  et_tafel('Bu')
  et_tafel(711, alter=100)
  et_tafel(611, bon=2.3)
  et_tafel(511, alter=80, bon=-0.5)

}
\references{
Albert M., Nagel J., Schmidt M., Nagel R.-V., Spellmann H. (2021): Eine neue
Generation von Ertragstafeln für Eiche, Buche, Fichte, Douglasie und Kiefer
[Datensatz]. Version 1.0. Zenodo. https://doi.org/10.5281/zenodo.6343906
}
\seealso{
Informationen über vorhandene Tafeln \code{\link[=et_liste]{et_liste()}}, \code{\link[=et_info]{et_info()}},
Bonitieren \code{\link[=et_bonitaet]{et_bonitaet()}}.
}
\author{
Robert Nuske
}
