% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{hedg_g}
\alias{hedg_g}
\title{Compute Hedges' \emph{g}
This function calculates effect sizes in terms of Hedges' \emph{g}, also
called the corrected (for sample size) effect size. See
\code{\link{coh_d}} for the uncorrected version. Also see 
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3840331/}{Lakens (2013)}
for a discussion on different types of effect sizes and their
interpretation. Note that missing data are removed from the calculations of 
the means and standard deviations.}
\usage{
hedg_g(data, formula, ref_group = NULL, keep_d = TRUE)
}
\arguments{
\item{data}{The data frame used for estimation - ideally structured in a tidy 
format.}

\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups. Additional variables 
can be included with \code{+} to produce separate estimates by the secondary 
or tertiary variables of interest (e.g., \code{out ~ group + characteristic1 
+ characteristic2}).}

\item{ref_group}{Optional. A character vector or forumla listing the 
reference group levels for each variable on the right hand side of the 
formula, supplied in the same order as the formula. Note that if using the
formula version, levels that are numbers, or include hyphens, spaces, etc., 
should be wrapped in back ticks (e.g., 
\code{ref_group = ~ Active + `Non-FRL`}, or \code{ref_group = ~`8`}). When 
in doubt, it is safest to use the back ticks, as they will not interfere 
with anything if they are not needed. See examples below for more details.}

\item{keep_d}{Logical. Should Cohen's \emph{d} be reported along with 
Hedge's \code{g}? Defaults to \code{TRUE}.}
}
\value{
By default the Hedges' \emph{g} for all possible pairings of
 the grouping factor are returned as a tidy data frame.
}
\description{
Compute Hedges' \emph{g}
This function calculates effect sizes in terms of Hedges' \emph{g}, also
called the corrected (for sample size) effect size. See
\code{\link{coh_d}} for the uncorrected version. Also see 
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3840331/}{Lakens (2013)}
for a discussion on different types of effect sizes and their
interpretation. Note that missing data are removed from the calculations of 
the means and standard deviations.
}
\examples{

# Calculate Hedges' g for all pairwise comparisons
hedg_g(star, reading ~ condition) 

# Report only relative to regular-sized classrooms
hedg_g(star, 
       reading ~ condition, 
       ref_group = "reg")

# Report by ELL and FRL groups for each season, compare to non-ELL students
# who were not eligible for free or reduced price lunch in the fall (using
# the formula interface for reference group referencing).

hedg_g(benchmarks, 
      math ~ ell + frl + season,
      ref_group = ~`Non-ELL` + `Non-FRL` + Fall)

# Same thing but with character vector supplied, rather than a formula
hedg_g(benchmarks, 
      math ~ ell + frl + season,
      ref_group = c("Non-ELL", "Non-FRL", "Fall"))
}
