% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matriz.correlacion.R
\name{matriz.correlacion}
\alias{matriz.correlacion}
\title{Matriz de correlación.}
\usage{
matriz.correlacion(x, variable = NULL, exportar = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Es un dataframe con al menos 2 variables (2 columnas).}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} solo tiene 2 variables (columnas), \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de las variables a seleccionar.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
La función devuelve la matriz de correlación lineal de las variables seleccionadas en un \code{data.frame}.
}
\description{
Obtiene la matriz de correlación (de Pearson) entre 2 o más variables cuantitativas.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrcorrelacion.png}{width = 200px}}
\if{latex}{\figure{qrcorrelacion.png}{options: width=3cm}}
}
\details{
Se obtiene la matriz de correlación muestral:

\if{html}{\figure{matrizcorrelacion.png}{width = 400px}}
\if{latex}{\figure{matrizcorrelacion.png}{options: width=8cm}}
}
\note{
Si en lugar del tamaño muestral (n) se utiliza el tamaño de la población (N) se obtiene la matriz de correlació poblacional:

\if{html}{\figure{matrizcorrelacionpob.png}{width = 440px}}
\if{latex}{\figure{matrizcorrelacionpob.png}{options: width=8cm}}
}
\examples{

matriz_cor <- matriz.correlacion(startup)


}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{correlacion}}, \code{\link{covarianza}},\code{\link{matriz.covar}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
