# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @keywords internal
l_esreg_covariance <- function(xq, xe, xbq, xbe, G1_prime_xq, G2_xe, G2_prime_xe, density, conditional_variance, alpha) {
    .Call('_esreg_l_esreg_covariance', PACKAGE = 'esreg', xq, xe, xbq, xbe, G1_prime_xq, G2_xe, G2_prime_xe, density, conditional_variance, alpha)
}

#' @keywords internal
lambda_matrix_loop <- function(xq, xe, xbq, xbe, G1_prime_xq, G1_prime_prime_xq, G2_xe, G2_prime_xe, G2_prime_prime_xe, density, cdf, alpha, include_misspecification_terms) {
    .Call('_esreg_lambda_matrix_loop', PACKAGE = 'esreg', xq, xe, xbq, xbe, G1_prime_xq, G1_prime_prime_xq, G2_xe, G2_prime_xe, G2_prime_prime_xe, density, cdf, alpha, include_misspecification_terms)
}

#' @keywords internal
sigma_matrix_loop <- function(xq, xe, xbq, xbe, G1_prime_xq, G2_xe, G2_prime_xe, conditional_variance, cdf, alpha, include_misspecification_terms) {
    .Call('_esreg_sigma_matrix_loop', PACKAGE = 'esreg', xq, xe, xbq, xbe, G1_prime_xq, G2_xe, G2_prime_xe, conditional_variance, cdf, alpha, include_misspecification_terms)
}

#' @keywords internal
estimating_function_loop <- function(y, xq, xe, xbq, xbe, G1_prime_xq, G2_xe, G2_prime_xe, alpha) {
    .Call('_esreg_estimating_function_loop', PACKAGE = 'esreg', y, xq, xe, xbq, xbe, G1_prime_xq, G2_xe, G2_prime_xe, alpha)
}

#' @title Specification Function
#' @description G1
#' @param z Data
#' @param type Choice of the G1 function:
#' \itemize{
#'   \item 1: G1(z) = z
#'   \item 2: G1(z) = 0
#' }
#' @keywords internal
#' @export
G1_fun <- function(z, type) {
    .Call('_esreg_G1_fun', PACKAGE = 'esreg', z, type)
}

#' @title Specification Function
#' @description G1_prime
#' @param z Data
#' @param type Choice of the G1_prime function:
#' \itemize{
#'   \item 1: G1_prime(z) = 1
#'   \item 2: G1_prime(z) = 0
#' }
#' @keywords internal
#' @export
G1_prime_fun <- function(z, type) {
    .Call('_esreg_G1_prime_fun', PACKAGE = 'esreg', z, type)
}

#' @title Specification Function
#' @description G1_prime_prime
#' @param z Data
#' @param type Choice of the G1_prime_prime function:
#' \itemize{
#'   \item 1: G1_prime(z) = 0
#'   \item 2: G1_prime(z) = 0
#' }
#' @keywords internal
#' @export
G1_prime_prime_fun <- function(z, type) {
    .Call('_esreg_G1_prime_prime_fun', PACKAGE = 'esreg', z, type)
}

#' @title Specification Function
#' @description G2_curly
#' @param z Data
#' @param type Choice of the G2_curly function:
#' \itemize{
#'   \item 1: -log(-z), z < 0
#'   \item 2: -sqrt(-z), z < 0
#'   \item 3: -1/z, z < 0
#'   \item 4: log(1 + exp(z))
#'   \item 5: exp(z)
#' }
#' @keywords internal
#' @export
G2_curly_fun <- function(z, type) {
    .Call('_esreg_G2_curly_fun', PACKAGE = 'esreg', z, type)
}

#' @title Specification Function
#' @description G2
#' @param z Data
#' @param type Choice of the G2 function:
#' \itemize{
#'   \item 1: -1/z, z < 0
#'   \item 2: 0.5/sqrt(-z), z < 0
#'   \item 3: 1/z^2, z < 0
#'   \item 4: 1 / (1 + exp(-z))
#'   \item 5: exp(z)
#' }
#' @keywords internal
#' @export
G2_fun <- function(z, type) {
    .Call('_esreg_G2_fun', PACKAGE = 'esreg', z, type)
}

#' @title Specification Function
#' @description G2_prime
#' @param z Data
#' @param type Choice of the G2_prime function:
#' \itemize{
#'   \item 1: 1/z^2, z < 0
#'   \item 2: 0.25 / (-z)^(3/2), z < 0
#'   \item 3: -2/z^3, z < 0
#'   \item 4: exp(z) / (1 + exp(z))^2
#'   \item 5: exp(z)
#' }
#' @keywords internal
#' @export
G2_prime_fun <- function(z, type) {
    .Call('_esreg_G2_prime_fun', PACKAGE = 'esreg', z, type)
}

#' @title Specification Function
#' @description G2_prime_prime
#' @param z Data
#' @param type Choice of the G2_prime_prime function:
#' \itemize{
#'   \item 1: -2/z^3, z < 0
#'   \item 2: 0.375 / (-z)^(5/2), z < 0
#'   \item 3: 6/z^4, z < 0
#'   \item 4: -(exp(z) * (exp(z) - 1)) / (exp(z) + 1)^3
#'   \item 5: exp(z)
#' }
#' @keywords internal
#' @export
G2_prime_prime <- function(z, type) {
    .Call('_esreg_G2_prime_prime', PACKAGE = 'esreg', z, type)
}

#' @title Vectorized call to the G1 / G2 functions
#' @description Vectorized call to the G1 / G2 functions
#' @param z Vector
#' @param g String, either G1, G1_prime, G2_curly, G2 or G2_curly
#' @param type Numeric, for G1: 1-2; G2: 1-5
#' (see \link{G1_fun}, \link{G1_prime_fun}, \link{G2_curly_fun}, \link{G2_fun}, \link{G2_prime_fun})
#' @keywords internal
#' @export
G_vec <- function(z, g, type) {
    .Call('_esreg_G_vec', PACKAGE = 'esreg', z, g, type)
}

#' @title Joint (VaR, ES) loss for a linear predictor
#' @description Returns the loss for the parameter vector b
#' @param b Parameter vector
#' @param y Vector of dependent data
#' @param xq Matrix of covariates for the quantile part
#' @param xe Matrix of covariates for the expected shortfall part
#' @param alpha Probability level
#' @param g1 1, 2 (see \link{G1_fun})
#' @param g2 1, 2, 3, 4, 5 (see \link{G2_curly_fun}, \link{G2_fun})
#' @importFrom Rcpp sourceCpp
#' @useDynLib esreg
#' @keywords internal
#' @export
esr_rho_lp <- function(b, y, xq, xe, alpha, g1 = 2L, g2 = 1L) {
    .Call('_esreg_esr_rho_lp', PACKAGE = 'esreg', b, y, xq, xe, alpha, g1, g2)
}

