% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esquisserServer.R, R/esquisserUI.R
\name{esquisserServer}
\alias{esquisserServer}
\alias{esquisse-module}
\alias{esquisserUI}
\title{Esquisse Shiny module}
\usage{
esquisserServer(input, output, session, data = NULL,
  dataModule = c("GlobalEnv", "ImportFile"), sizeDataModule = "m")

esquisserUI(id, header = TRUE, choose_data = TRUE)
}
\arguments{
\item{input}{standard \code{shiny} input}

\item{output}{standard \code{shiny} output}

\item{session}{standard \code{shiny} session}

\item{data}{a \code{reactiveValues} with at least a slot \code{data} containing a \code{data.frame}
to use in the module. And a slot \code{name} corresponding to the name of the \code{data.frame}.}

\item{dataModule}{Data module to use, choose between \code{"GlobalEnv"}
or \code{"ImportFile"}.}

\item{sizeDataModule}{Size for the modal window for selecting data.}

\item{id}{Module's id.}

\item{header}{Logical. Display or not \code{esquisse} header.}

\item{choose_data}{Logical. Display or not the button to choose data.}
}
\description{
Launch \code{esquisse} in a classic Shiny app.
}
\note{
For the module to display correctly, it is necessary to place it in a container with a fixed height.
}
\examples{

if (interactive()) {


### Part of a Shiny app ###

library(shiny)
library(esquisse)

ui <- fluidPage(
  tags$h1("Use esquisse as a Shiny module"),
  radioButtons(
    inputId = "data", 
    label = "Data to use:", 
    choices = c("iris", "mtcars"),
    inline = TRUE
  ),
  tags$div(
    style = "height: 700px;", # needs to be in fixed height container
    esquisserUI(
      id = "esquisse", 
      header = FALSE, # dont display gadget title
      choose_data = FALSE # dont display button to change data
    )
  )
)

server <- function(input, output, session) {
  
  data_r <- reactiveValues(data = iris, name = "iris")
  
  observeEvent(input$data, {
    if (input$data == "iris") {
      data_r$data <- iris
      data_r$name <- "iris"
    } else {
      data_r$data <- mtcars
      data_r$name <- "mtcars"
    }
  })
  
  callModule(module = esquisserServer, id = "esquisse", data = data_r)
  
}

shinyApp(ui, server)



### Whole Shiny app ###

library(shiny)
library(esquisse)


# Load some datasets in app environment
my_data <- data.frame(
  var1 = rnorm(100),
  var2 = sample(letters[1:5], 100, TRUE)
)



ui <- fluidPage(
  tags$div( # needs to be in fixed height container
    style = "position: fixed; top: 0; bottom: 0; right: 0; left: 0;", 
    esquisserUI(id = "esquisse")
  )
)

server <- function(input, output, session) {
  
  callModule(module = esquisserServer, id = "esquisse")
  
}

shinyApp(ui, server)

}

}
