% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histo_DVH.R
\name{histo.DVH}
\alias{histo.DVH}
\title{Cumulative Dose Volume Histogram}
\usage{
histo.DVH(histo, alias = "", description = histo$description)
}
\arguments{
\item{histo}{"histo" class object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.
If the \code{description = NULL} (default value), it will be set to
\code{histo$description}.}
}
\value{
Returns a "dvh" class object. This is a list including:
\itemize{
\item \code{$patient}: set to \code{histo$patient}.
\item \code{$patient.name}: set to \code{histo$patient.name}.
\item \code{$patient.bd}: set to \code{histo$patient.bd}.
\item \code{$patient.sex}: set to \code{histo$patient.sex}.
\item \code{$file.basename}: set to "".
\item \code{$file.dirname}: set to "".
\item \code{$object.name}: set to "".
\item \code{$object.alias}: alias of the dvh object..
\item \code{$frame.of.reference}: set to \code{histo$frame.of.reference}.
\item \code{$ref.pseudo} : set to \code{histo$ref.pseudo}.
\item \code{$modality} : set to \code{"dvh"}.
\item \code{$description}: description of  the dvh object. By default,
set to \code{histo$description}.
\item \code{$creation.date}: set to \code{Sys.Date}.
\item \code{$nb.MC}: set to \code{histo$nb.MC}.
\item \code{$breaks}: vector breakpoints.
\item \code{$mids}: vector of cell centers.
\item \code{$mids.unit}: Character string, representing the unit of the abcissa
of the DVH. For instance, "Gy", when \code{vol} is a rtdose.
\item \code{$vol}: cumulative volume receiving at least the doses defined by \code{$mids}.
\item \code{$pcv}: percentage of the total volume receiving at least the doses defined by \code{$mids}.
\item \code{$MC.vol}: cumulative volume associated with \code{histo$MC.dV_dx}, if it exists.
\item \code{$MC.pcv}: percentage of the total volume associated with \code{histo$MC.dV_dx}, if it exists.
\item \code{$MC.dxyz}: set to \code{histo$MC.dxyz}, if it exists.
}
}
\description{
The \code{histo.DVH} function calculates, for each dose,
the volume receiving at least this dose.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose", "rtstruct"), 
                             roi.name = "gizzard", dxyz = rep (step, 3), 
                             beam.nb = 3)

# Calculation of the histogram
H <- histo.from.roi (patient$rtdose[[1]], patient$rtstruct[[1]], 
                     roi.name = "gizzard", 
                     breaks = seq (0, 60, by = 1))

# DVH
DVH <- histo.DVH (H)
str (DVH)
}
\seealso{
\link[espadon]{histo.from.roi}, \link[espadon]{histo.from.bin},
\link[espadon]{histo.vol}, \link[espadon]{display.DVH}, \link[espadon]{display.DVH.pc}
}
