% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_hvratio.R
\name{signal_hvratio}
\alias{signal_hvratio}
\title{Calculate h-v-ratio of seismic components}
\usage{
signal_hvratio(
  data,
  dt,
  log = FALSE,
  method = "periodogram",
  kernel,
  order = "xyz"
)
}
\arguments{
\item{data}{\code{List}, \code{data frame} or \code{matrix}, seismic
componenents to be processed. If \code{data} is a matrix, the components 
must be organised as columns. Also, \code{data} can be a list of 
\code{eseis} objects.}

\item{dt}{\code{Numeric} value, sampling period.}

\item{log}{\code{Logical} value, unit of spectral power. If set to 
\code{TRUE} power will be used in dB, if set to \code{FALSE}, power 
is used in amplitude squared. Default is \code{FALSE}.}

\item{method}{\code{Character} value, method for calculating the spectra. 
One out of \code{"periodogram"} , \code{"autoregressive"} and 
\code{"multitaper"}, default is \code{"periodogram"}.}

\item{kernel}{\code{Numeric} value, window size (number of samples) of 
the moving window used for smoothing the spectra. By default no smoothing 
is performed.}

\item{order}{\code{Character} value, order of the seismic components. 
Describtion must contain the letters \code{"x"},\code{"y"} and
\code{"z"} in the order according to the input data set. Default is 
\code{"xyz"} (EW-SN-vertical).}
}
\value{
A \code{data frame} with the h-v-frequency ratio.
}
\description{
This function uses three components of a seismic signal, evaluates 
their spectra and builds the ratio of horizontal to vertical power. 
For details see http://www.geopsy.org/documentation/geopsy/hv.html.
}
\details{
The spectra should be smoothed. This can either be done directly 
during their calculation or before the calculation of the ratio. For 
the former case set \code{method = "autoregressive"}. For the latter 
case provide a value for \code{"kernel"}, which is the smoothing 
window size. Smoothing is performed with the logarithms of the spectral 
power data, using \code{caTools::runmean()} with the 
\code{endrule = "NA"}. After smoothing the data is re-linearised.
}
\examples{
## load example data set
data(earthquake)

## ATTENTION, THIS EXAMPLE DATA SET IS FAR FROM IDEAL FOR THIS PURPOSE

## detrend data
s <- signal_detrend(data = s)

## calculate h-v-ratio, will be very rugged
hv <- signal_hvratio(data = s, 
                     dt = 1 / 200)
plot(hv$ratio, 
     type = "l")

## calculate h-v-ratio using the autogressive spectrum method
hv <- signal_hvratio(data = s, 
                     dt = 1 / 200, 
                     method = "autoregressive")
plot(hv, type = "l")

## calculate h-v-ratio with a smoothing window equivalent to dt
hv <- signal_hvratio(data = s, 
                     dt = 1 / 200,
                     kernel = 200)
plot(hv, type = "l")

}
\author{
Michael Dietze
}
\keyword{eseis}
