% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_pmax.R
\name{spatial_pmax}
\alias{spatial_pmax}
\title{Get most likely source location}
\usage{
spatial_pmax(data)
}
\arguments{
\item{data}{\code{SpatRaster} object, spatial data set with source location
estimates.}
}
\value{
\code{data.frame}, coordinates (x and y) of the most likely s
ource location(s).
}
\description{
The function identifies the location of a seismic source with the 
heighest likelihood (P_max).
}
\examples{

## create example source location likelihood raster
x <- terra::rast(nrows = 100, ncols = 100, 
                 xmin = 0, xmax = 10, 
                 ymin = 0, ymax = 10)
terra::values(x) <- runif(n = 100)

## identify location of highest likelihood
p_max <- spatial_pmax(data = x)

## show result
print(p_max)

}
\author{
Michael Dietze
}
\keyword{eseis}
