% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectrum.R
\name{plot_spectrum}
\alias{plot_spectrum}
\title{Plot a spectrum of a seismic signal}
\usage{
plot_spectrum(data, unit = "dB", n = 10000, ...)
}
\arguments{
\item{data}{\code{eseis} object or \code{data frame} with two elements,
\code{frequency} vector and \code{spectrum} vector.}

\item{unit}{\code{Character} value. One out of \code{"linear"}, 
\code{"log"}, \code{"dB"}. Default is \code{"dB"}.}

\item{n}{\code{Numeric} value, number of values to which the dataset 
is reduced. Default is \code{10000}.}

\item{\dots}{Further arguments passed to the plot function.}
}
\value{
A line plot.
}
\description{
This function plots a line graph of the spectrum of a seismic signal.
}
\examples{

## load example data set
data(rockfall)

## calculate spectrum
spectrum_rockfall <- signal_spectrum(data = rockfall_eseis)

## plot data set with lower resolution
plot_spectrum(data = spectrum_rockfall)

}
\seealso{
\code{\link{signal_spectrum}}
}
\author{
Michael Dietze
}
\keyword{eseis}
