% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_kurtosis.R
\name{pick_kurtosis}
\alias{pick_kurtosis}
\title{Kutosis based event picking}
\usage{
pick_kurtosis(
  data,
  on,
  off = 1,
  dur_min = 0,
  dur_max,
  window_kurt,
  window_amp,
  time,
  dt
)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{on}{\code{Numeric} value, kurtosis threshold that defines the 
onset of an event.}

\item{off}{\code{Numeric} value, ratio of average post and pre event
signal amplitude inside a running window. Default is \code{1}.}

\item{dur_min}{\code{Numeric} value, minimum duration of the event. This 
is required as the kurtosis routine tends to identify multipe picks in 
the beginning of an event.}

\item{dur_max}{\code{Numeric} value, maximum duration of the event. This
value can be omitted but would increase computational speed as it 
determines the length of samples to look for the amplitude ratio that 
signals the end of an event}

\item{window_kurt}{\code{Numeric} value, size of the running window (in
number of samples) in which the kurtosis is calculated.}

\item{window_amp}{\code{Numeric} value, size of the running window (in
number of samples) in which the running mean is calculated.}

\item{time}{\code{POSIXct} vector, time vector of the signal(s). If not 
provided, a synthetic time vector will be created.}

\item{dt}{\code{Numeric} value, sampling period. If omitted, either 
estimated from \code{time} or set to 0.01 s (i.e., f = 100 Hz).}
}
\value{
\code{data.frame}, picked events.
}
\description{
The function picks (identifies) events from continuous data using the 
kurtosis of the signal, and when it reaches beyond a defined threshold 
value. The end of an event is determined by the signal-to-noise ratio 
(SNR)
}
\details{
Further reading: 

Baillard, C., Crawford, W.C., Ballu, V., Hibert, C., Mangeney, A., 2014. 
An automatic kurtosis-based p- and s-phase picker designed for local 
seismic networks. Bull. Seismol. Soc. Am. 104 (1), 394–409.

Hibert, C., Mangeney, A., Grandjean, G., Baillard, C., Rivet, D., 
Shapiro, N.M., Satriano, C., Maggi, A., Boissier, P., Ferrazzini, V., 
Crawford, W., 2014. Automated identification, location, and volume 
estimation of rockfalls at Piton de la Fournaise Volcano. J. Geophys. 
Res. Earth Surf. 119 (5), 
1082–1105. http://dx.doi.org/10.1002/2013JF002970.
}
\examples{

## load example data set
data(rockfall)

## preprocess signal (aggregate to increase speed, filter, envelope)
s <- signal_aggregate(data = rockfall_eseis, n = 4)
s <- signal_filter(data = s, f = c(5, 20), lazy = TRUE)
e <- signal_envelope(data = s)

## pick events based on signal kurtosis
p <- eseis::pick_kurtosis(data = e, 
                          window_kurt = 200, 
                          on = 15, 
                          off = 5, 
                          dur_min = 10, 
                          dur_max = 90, 
                          window_amp = 300)

p$picks
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
