% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_phase1_2_outcomes.R
\name{parse_phase1_2_outcomes}
\alias{parse_phase1_2_outcomes}
\title{Parse a string of phase I/II dose-finding outcomes to vector notation.}
\usage{
parse_phase1_2_outcomes(outcomes, as_list = TRUE)
}
\arguments{
\item{outcomes}{character string, conveying doses given and outcomes
observed.}

\item{as_list}{TRUE (the default) to return a \code{list};
FALSE to return a \code{data.frame}}
}
\value{
If \code{as_list == TRUE}, a list with elements \code{eff},
\code{tox}, \code{dose} and \code{num_patients}. If \code{as_list == FALSE},
a data.frame with columns \code{eff}, \code{tox} and \code{dose}.
}
\description{
Parse a string of phase I/II dose-finding outcomes to a binary
vector notation necessary for model invocation.

The outcome string describes the doses given, outcomes observed and groups
patients into cohorts. The format of the string is described in Brock et al.
(2017). See Examples.

The letters E, T, N and B are used to represents patients that
experienced (E)fficacy only, (T)oxicity only, (B)oth efficacy and toxicity,
and (N)either. These letters are concatenated after numerical dose-levels to
convey the outcomes of cohorts of patients. For instance, \code{2ETB}
represents a cohort of three patients that were treated at dose-level 2, and
experienced efficacy, toxicity and both events, respectively. The results of
cohorts are separated by spaces. Thus, \code{2ETB 1NN} extends our previous
example, where the next cohort of two were treated at dose-level 1 and both
patients experienced neither efficacy nor toxicity. See Examples.
}
\examples{
x = parse_phase1_2_outcomes('1NNE 2EEN 3TBB')
# Three cohorts of three patients. The first cohort was treated at dose 1 and
# had no toxicity with one efficacy, etc.
x$num_patients  # 9
x$dose         # c(1, 1, 1, 2, 2, 2, 3, 3, 3)
x$eff           # c(0, 0, 1, 1, 1, 0, 0, 1, 1)
sum(x$eff)      # 5
x$tox           # c(0, 0, 0, 0, 0, 0, 1, 1, 1)
sum(x$tox)      # 3

# The same information can be parsed to a data-frame:
y = parse_phase1_2_outcomes('1NNE 2EEN 3TBB', as_list = FALSE)
y
}
\references{
Brock, K., Billingham, L., Copland, M., Siddique, S., Sirovica, M., & Yap, C.
(2017). Implementing the EffTox dose-finding design in the Matchpoint trial.
BMC Medical Research Methodology, 17(1), 112.
https://doi.org/10.1186/s12874-017-0381-x
}
