% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_esc.R
\name{write_esc}
\alias{write_esc}
\title{Write one or more 'esc' objects into an Excel csv-file}
\usage{
write_esc(..., path, sep = ",")
}
\arguments{
\item{...}{One or more objects of class \code{esc}}

\item{path}{Path to write to, or just file name (to write to working directory).}

\item{sep}{The field separator string. In some Western European locales, Excel
uses a semicolon by default, while in other locales the field
separator string in Excel is a comma.}
}
\value{
Invisibly returns the combined data frame that is written to
        the csv-file (see \code{\link{combine_esc}}).
}
\description{
This method is a small wrapper to write csv-files. It writes
             the results from \code{\link{combine_esc}} into an Excel csv-file.
}
\note{
For Western European locales, the \code{sep}-argument probably needs to
      be set to semicolon (\code{sep = ";"}), so Excel reads the csv-file properly.
      If \code{sep = ";"}, \code{\link[utils]{write.csv2}} is used to write the
      file. Else, \code{\link[readr]{write_excel_csv}} is used.
}
\examples{
e1 <- esc_2x2(grp1yes = 30, grp1no = 50, grp2yes = 40,
              grp2no = 45, study = "Study 1")
e2 <- esc_2x2(grp1yes = 30, grp1no = 50, grp2yes = 40, grp2no = 45,
              es.type = "or", study = "Study 2")
e3 <- esc_t(p = 0.03, grp1n = 100, grp2n = 150, study = "Study 3")
e4 <- esc_mean_sd(grp1m = 7, grp1sd = 2, grp1n = 50, grp2m = 9, grp2sd = 3,
                  grp2n = 60, es.type = "logit", study = "Study 4")

# write to current working directory,
# file extension ".csv" is automatically added
\dontrun{
write_esc(e1, e2, e3, e4, path = "EffSizes")}

}
\seealso{
\code{\link{combine_esc}}
}

