% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED1_SSR.boundary}
\alias{AED1_SSR.boundary}
\title{Calculate the critical value used at the final analysis of the
  Adaptive Enrichment Design (Strategy 1) with Sample Size Re-estimation Procedure}
\usage{
AED1_SSR.boundary(alpha, Info, K = 2)
}
\arguments{
\item{alpha}{The overall Type I error rate}

\item{Info}{The observation information, which is commonly calculated through
the sample size used at each stage of the trial.}

\item{K}{The number of subgroups. The default value is 2.}
}
\description{
The \code{AED1_SSR.boundary()} is used to calculate the critical
  value required at the final analysis of the Adaptive Enrichment Design
  (Strategy 1) with sample size
  re-estimation procedure. In the AED1-SSR design, the adaptive enrichment
  strategy is guided by a pre-specified futility stopping boundary and a
  threshold of the difference between the subgroup-specific test statistics.
}
\examples{
alpha <- 0.05
Info <- 0.5
K <- 2
AED1_SSR.boundary(alpha = alpha, Info = Info, K = K)

}
\references{
\itemize{
  \item Chang, M., and Wang, J. (2015). The add-arm design for unimodal
        response curve with unknown mode. Journal of biopharmaceutical
        statistics, 25(5), 1039-1064. <doi:10.1080/10543406.2014.971164.>
  \item Zhao Yang, Ruitao Lin, Guosheng Yin and Ying Yuan. (2018) Sample Size
    Re-estimation in Adaptive Enrichment Trials. (In preparation)
}
}
