% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_weights.R
\name{expand_weights}
\alias{expand_weights}
\title{Create a weight matrix}
\usage{
expand_weights(dat, weight = NULL, as.data.frame = FALSE, ...)
}
\arguments{
\item{dat}{\code{data.frame} the data to be checked}

\item{weight}{weight specification, see details.}

\item{as.data.frame}{if \code{TRUE} a \code{data.frame} will be returned.}

\item{...}{unused}
}
\value{
\code{matrix} or \code{data.frame} of same dimensions as \code{dat}
}
\description{
Expands a weight specification into a weight matrix to be used
by \code{locate_errors} and \code{replace_errors}. Weights allow for "guiding" the
errorlocalization process, so that less reliable values/variables with less
weight are selected first. See details on the specification.
}
\details{
If weight fine tuning is needed,
a possible scenario is to generate a weight \code{data.frame} using \code{expand_weights} and
adjust it before executing \code{\link[=locate_errors]{locate_errors()}} or \code{\link[=replace_errors]{replace_errors()}}.
The following specifications for \code{weight} are supported:
\itemize{
\item \code{NULL}: generates a weight matrix with \code{1}'s
\item a named \code{numeric}, unmentioned columns will have weight 1
\item a unnamed \code{numeric} with a length equal to \code{ncol(dat)}
\item a \code{data.frame} with same number of rows as \code{dat}
\item a \code{matrix} with same number of rows as \code{dat}
\item \code{Inf}, \code{NA} weights will be interpreted as that those variables must not be
changed and are fixated. \code{Inf} weights perform much better than setting a weight
to a large number.
}
}
\examples{
dat <- read.csv(text=
"age,country
  49,     NL
  23,     DE
", strip.white=TRUE)

weight <- c(age = 2, country = 1)
expand_weights(dat, weight)

weight <- c(2, 1)
expand_weights(dat, weight, as.data.frame = TRUE)

# works too
weight <- c(country=5)
expand_weights(dat, weight)

# specify a per row weight for country
weight <- data.frame(country=c(1,5))
expand_weights(dat, weight)

# country should not be changed!
weight <- c(country = Inf)
expand_weights(dat, weight)
}
\seealso{
Other error finding: 
\code{\link{errorlocation-class}},
\code{\link{errors_removed}()},
\code{\link{locate_errors}()},
\code{\link{replace_errors}()}
}
\concept{error finding}
