% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_R_ww.R
\name{estimate_R_ww}
\alias{estimate_R_ww}
\title{Estimate the effective reproduction from wastewater concentration
data.}
\usage{
estimate_R_ww(
  ww.conc,
  dist.fec,
  dist.gi,
  scaling.factor = 1,
  prm.smooth = list(window = 14, align = "center", method = "loess", span = 0.2),
  prm.R = list(iter = 10, CI = 0.95, window = 7, config.EpiEstim = NULL),
  silent = FALSE,
  RL.max.iter = 9
)
}
\arguments{
\item{ww.conc}{Data frame. Must have variables:
\itemize{
\item \code{date}: calendar date of wastewater collection
\item \code{value}: pathogen concentration
}}

\item{dist.fec}{List. Parameters for the fecal shedding distribution in the same format as returned by \code{\link[=def_dist_fecal_shedding]{def_dist_fecal_shedding()}}.}

\item{dist.gi}{List. Parameters for the generation interval distribution in the same format as returned by \code{\link[=def_dist_generation_interval]{def_dist_generation_interval()}}.}

\item{scaling.factor}{Numeric. Scaling from wastewater concentration to
prevalence. This value may be assumed or independently calibrated to data.}

\item{prm.smooth}{List. list of smoothing parameters. Parameters should be
specified as followed:
\itemize{
\item \code{method}: smoothing method, either \code{'rollmean'} (rolling mean) or \code{'loess'} (LOESS smoothing)
\item \code{window}: for \verb{method = 'rollmean} only; width of smoothing window in days
\item \code{align}: for \verb{method = 'rollmean} only; smoothing alignment, either \code{'center'}, \code{'left'}, \code{'right'}
\item \code{span}: for \code{method = 'loess'} only; smoothing span (see the documentation for \code{stats::loess()} for details)
\item \code{floor}: optional call for wastewater concentration smoothing with \code{method = 'loess'} only; user defined minimum smoothing concentration
}
Set this entire list to \code{NULL} to turn off smoothing}

\item{prm.R}{List. Settings for the ensemble when calculating Rt.
Elements include:
\itemize{
\item \code{iter}: Integer. Number of iterations for the Rt ensemble
\item \code{CI}: Numeric between 0 and 1. Confidence interval width for Rt
estimates after sampling uncertain distributions.
\item \code{window}: Integer. Number of days defining the window of data used by
\code{EpiEstim} to estimate Rt. If \code{NULL}, will default to 7.
\item \code{config.EpiEstim}: (optional) configuration for \code{EpiEstim} defined via
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}. If \code{NULL}, will use default config from
\code{EpiEstim}.
}}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}

\item{RL.max.iter}{Integer. Maximum of iterations for the Richardson-Lucy deconvolution algorithm.}
}
\value{
List. Elements include:
\itemize{
\item \code{ww.conc}: original wastewater signal
\item \code{ww.smooth}: smoothed wastewater signal
\item \code{inc}: inferred incidence
\item \code{R}: the effective reproduction number estimate
}
}
\description{
Estimate the effective reproduction from wastewater concentration
data.
}
\examples{

 # Load data of viral concentration in wastewater
data("ww.input")

# Run the estimation of Rt based on the wastewater data
x = estimate_R_ww(
  ww.conc  = ww.input,
  dist.fec = def_dist_fecal_shedding(pathogen = 'sarscov2'),
  dist.gi  = def_dist_generation_interval(pathogen = 'sarscov2'), 
  silent   = TRUE
)

# Rt estimates
head(x$R)

# inferred daily incidence
head(x$inc)


}
\seealso{
\code{\link[=plot_diagnostic_ww]{plot_diagnostic_ww()}} \code{\link[=estimate_R_cl]{estimate_R_cl()}}
}
