% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-content.R
\name{check_content}
\alias{check_content}
\title{Check Argument's Content}
\usage{
check_content(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  as_double = TRUE,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{valid}{can be
\enumerate{
\item a function, which takes \code{x} as argument and returns \code{TRUE} or \code{FALSE},
\item an expression, which contains \code{x} and evaluates to \code{TRUE} or \code{FALSE},
\item a string of R code, which evaluates to \code{TRUE} or \code{FALSE}, or
\item a non-empty atomic vector, which contains the valid choices.
}}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{as_double}{Optional. \code{TRUE} or \code{FALSE} which indicates if to
differentiate between type double and integer. The default value is
\code{TRUE}, which means integers are handled as doubles.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if an argument is from some given choices or satisfies
some requirement, and if not, generate an error message.
}
\examples{
valid <- c(1, 2, 3)

x <- 2L
check_content(x, valid)

\dontrun{
# `x` must have the same type with `valid`
x <- "a"
check_content(x, valid)

# `x` must have length 1
x <- c(1, 2)
check_content(x, valid)

# differentiate between type double and integer
x <- 2L
check_content(x, valid, as_double = FALSE)

# `valid` can be a function
check_content(x, is.na, general = "`x` must be `NA`.")

# `valid` can be a string of R code
check_content(x, "is.na(x)", general = "`x` must be `NA`.")
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
