% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\docType{package}
\name{ergmProposal}
\alias{ergmProposal}
\alias{ergm-proposals}
\alias{proposals-ergm}
\alias{ergm.proposals}
\alias{proposals.ergm}
\alias{InitErgmProposal}
\alias{InitWtErgmProposal}
\title{Metropolis-Hastings Proposal Methods for ERGM MCMC}
\description{
\code{\link{ergm}}  uses a Metropolis-Hastings (MH) algorithm to control the behavior of the Markov Chain
Monte Carlo (MCMC) for sampling networks.  The MCMC chain is intended to step around the sample space of
possible networks, selecting a network at regular intervals to evaluate the statistics in the model.  For
each MCMC step, \eqn{n} (\eqn{n=1} in the simple case) toggles are proposed to change the dyad(s) to the
opposite value. The probability of accepting the proposed change is determined by the MH acceptance ratio.
The role of the different MH methods implemented in \code{\link{ergm}} is to vary how the sets of dyads are
selected for toggle proposals.  This is used in some cases to improve the performance (speed and mixing) of
the algorithm, and in other cases to constrain the sample space. Proposals can also be searched via \code{\link{search.ergmProposals}}, and help for an individual proposal can be obtained with \verb{ergmProposal?<proposal>} or \code{help("<proposal>-ergmProposal")}.
}
\section{Implemented proposals for ergm models}{


\ergmCSS

\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatProposalsHtml(ergm:::.buildProposalsList(), keepProposal=TRUE)}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatProposalsText(ergm:::.buildProposalsList(), keepProposal=TRUE)}}
\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatProposalsLatex(ergm:::.buildProposalsList(), keepProposal=TRUE)}}
}

\references{
\itemize{
\item Goodreau SM, Handcock MS, Hunter DR, Butts CT, Morris M (2008a).  A \pkg{statnet} Tutorial.
\emph{Journal of Statistical Software}, 24(8). \doi{10.18637/jss.v024.i08}
\item Hunter, D. R. and Handcock, M. S. (2006) Inference in curved exponential family models for networks.
\emph{Journal of Computational and Graphical Statistics}.
\item Hunter DR, Handcock MS, Butts CT, Goodreau SM, Morris M (2008b). \pkg{ergm}:
A Package to Fit, Simulate and Diagnose Exponential-Family Models for
Networks. \emph{Journal of Statistical Software}, 24(3).
\doi{10.18637/jss.v024.i03}
\item Krivitsky PN (2012). Exponential-Family Random Graph Models for Valued
Networks. \emph{Electronic Journal of Statistics}, 2012, 6, 1100-1128.
\doi{10.1214/12-EJS696}
\item Morris M, Handcock MS, Hunter DR (2008). Specification of Exponential-Family Random Graph Models:
Terms and Computational Aspects. \emph{Journal of Statistical Software}, 24(4).
\doi{10.18637/jss.v024.i04}
}
}
\seealso{
\code{\link[=ergm-package]{ergm}} package, \code{\link{ergm}}, \code{\link{ergmConstraint}}, \code{\link{ergm_proposal}}
}
\keyword{models}
