% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{dsp-ergmTerm}
\alias{dsp-ergmTerm}
\alias{InitErgmTerm.dsp}
\title{Dyadwise shared partners}
\usage{
# binary: dsp(d)
}
\arguments{
\item{d}{a vector of distinct integers}
}
\description{
This term adds one
network statistic to the model for each element in \code{d} ; the \eqn{i} th
such statistic equals the number of dyads in the network with exactly
\code{d[i]} shared partners. This term can be used with directed and
undirected networks.
}
\note{
For directed networks, only outgoing two-path ("OTP") shared partners
are counted.  In other words, for a (directed) dyad \verb{(i,j)} in a directed graph, the number of
shared partners counted by \code{dsp} is the number of nodes \code{k} that have edges
\code{i -> k -> j}.  (These may also be called homogeneous shared partners.)  To
count other types of shared partners instead, see \code{ddsp}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{directed}
\concept{undirected}
