% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.simulate.R
\name{control.simulate.ergm}
\alias{control.simulate.ergm}
\alias{control.simulate.formula.ergm}
\alias{control.simulate}
\alias{control.simulate.formula}
\title{Auxiliary for Controlling ERGM Simulation}
\usage{
control.simulate.formula.ergm(MCMC.burnin = 10000,
  MCMC.interval = 1000, MCMC.prop.weights = "default",
  MCMC.prop.args = list(), MCMC.init.maxedges = 20000,
  MCMC.packagenames = c(), MCMC.runtime.traceplot = FALSE,
  network.output = "network", term.options = NULL, parallel = 0,
  parallel.type = NULL, parallel.version.check = TRUE, ...)

control.simulate(MCMC.burnin = 10000, MCMC.interval = 1000,
  MCMC.prop.weights = "default", MCMC.prop.args = list(),
  MCMC.init.maxedges = 20000, MCMC.packagenames = c(),
  MCMC.runtime.traceplot = FALSE, network.output = "network",
  term.options = NULL, parallel = 0, parallel.type = NULL,
  parallel.version.check = TRUE, ...)

control.simulate.formula(MCMC.burnin = 10000, MCMC.interval = 1000,
  MCMC.prop.weights = "default", MCMC.prop.args = list(),
  MCMC.init.maxedges = 20000, MCMC.packagenames = c(),
  MCMC.runtime.traceplot = FALSE, network.output = "network",
  term.options = NULL, parallel = 0, parallel.type = NULL,
  parallel.version.check = TRUE, ...)

control.simulate.ergm(MCMC.burnin = NULL, MCMC.interval = NULL,
  MCMC.prop.weights = NULL, MCMC.prop.args = NULL,
  MCMC.init.maxedges = NULL, MCMC.packagenames = NULL,
  MCMC.runtime.traceplot = FALSE, network.output = "network",
  term.options = NULL, parallel = 0, parallel.type = NULL,
  parallel.version.check = TRUE, ...)
}
\arguments{
\item{MCMC.burnin}{Number of proposals before any MCMC sampling is done. It
typically is set to a fairly large number.}

\item{MCMC.interval}{Number of proposals between sampled statistics.}

\item{MCMC.prop.weights}{Specifies the proposal distribution used in the
MCMC Metropolis-Hastings algorithm.  Possible choices are \code{"TNT"} or
\code{"random"}; the \code{"default"} is one of these two, depending on the
constraints in place (as defined by the \code{constraints} argument of the
\code{\link{ergm}} function), though not all weights may be used with all
constraints.  The \code{TNT} (tie / no tie) option puts roughly equal weight
on selecting a dyad with or without a tie as a candidate for toggling,
whereas the \code{random} option puts equal weight on all possible dyads,
though the interpretation of \code{random} may change according to the
constraints in place.  When no constraints are in place, the default is TNT,
which appears to improve Markov chain mixing particularly for networks with
a low edge density, as is typical of many realistic social networks.}

\item{MCMC.prop.args}{An alternative, direct way of specifying additional
arguments to proposal.}

\item{MCMC.init.maxedges}{Maximum number of edges expected in network.}

\item{MCMC.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{MCMC.runtime.traceplot}{Logical: If TRUE, plot traceplots of the MCMC
sample after every MCMC MLE iteration.}

\item{network.output}{R class with which to output networks. The options are
"network" (default) and "edgelist.compressed" (which saves space but only
supports networks without vertex attributes)}

\item{term.options}{A list of additional arguments to be passed to term initializers. It can also be set globally via \code{option(ergm.term=list(...))}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See the entry on \link[=ergm-parallel]{parallel processing}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported values
are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the \code{parallel}
package with PSOCK clusters. See \code{\link{ergm-parallel}}}

\item{parallel.version.check}{Logical: If TRUE, check that the version of
\code{\link[=ergm-package]{ergm}} running on the slave nodes is the same as
that running on the master node.}

\item{\dots}{Additional arguments, passed to other functions This argument
is helpful because it collects any control parameters that have been
deprecated; a warning message is printed in case of deprecated arguments.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning ERGM
simulation. \code{control.simulate}, \code{control.simulate.formula}, and
\code{control.simulate.formula.ergm} are all aliases for the same
function.

While the others supply a full set of simulation
settings, \code{control.simulate.ergm} when passed as a control
parameter to \code{\link[=simulate.ergm]{simulate.ergm()}} allows some settings to be
inherited from the ERGM stimation while overriding others.
}
\details{
This function is only used within a call to the \code{\link{simulate}}
function.  See the \code{usage} section in \code{\link{simulate.ergm}} for
details.
}
\seealso{
\code{\link{simulate.ergm}}, \code{\link{simulate.formula}}.
\code{\link{control.ergm}} performs a similar function for
\code{\link{ergm}}; \code{\link{control.gof}} performs a similar function
for \code{\link{gof}}.
}
\keyword{models}
