#  File ergm.userterms/R/zzz.R
#  Part of the statnet package, http://statnetproject.org
#
#  This software is distributed under the GPL-3 license.  It is free,
#  open source, and has the attribution requirements (GPL Section 7) in
#    http://statnetproject.org/attribution
#
#  Copyright 2011 the statnet development team
######################################################################
######################################################################
#
# .First.lib is run when the package is loaded.
#

.First.lib <- function(lib, pkg){
    library.dynam("ergm.userterms", pkg, lib)
    ergmdesc <- packageDescription("ergm.userterms")
    cat('\nergm.userterms:', gsub("\n"," ",ergmdesc$Title),
        '\nVersion', ergmdesc$Version, 'created on', ergmdesc$Date, '\n') 
    cat(paste("copyright (c) 2003, Mark S. Handcock, University of Washington\n",
"                    David R. Hunter, Penn State University\n",
"                    Carter T. Butts, University of California-Irvine\n",
"                    Steven M. Goodreau, University of Washington\n",
"                    Martina Morris, University of Washington\n",sep=""))
    cat('Type help(package="ergm.userterms") to get started.\n\n')
    cat('Based on "statnet" project software (http://statnetproject.org).\n',
        'For license and citation information type citation("ergm.userterms")\n',
        'or see http://statnetproject.org/attribution\n')
}

.Last.lib <- function(libpath){
  library.dynam.unload("ergm.userterms",libpath)
}
