% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{odegreeL-ergmTerm}
\alias{odegreeL-ergmTerm}
\alias{InitErgmTerm.odegreeL}
\title{Out-degree}
\usage{
# binary: odegreeL(d, by=NULL, homophily=FALSE, levels=NULL)
}
\arguments{
\item{d}{a vector of distinct integers}

\item{by}{a character string giving the name of an attribute in the
network's vertex attribute list.}

\item{homophily}{If this is specified and \code{homophily} is \code{TRUE} ,
then degrees are calculated using the subnetwork consisting of only
edges whose endpoints have the same value of the \code{by} attribute.
If \code{by} is specified and
\code{homophily} is \code{FALSE} (the default), then separate degree
statistics are calculated for nodes having each separate
value of the attribute.}

\item{Ls}{either a Layer Logic specification formula (c.f. Layer Logic section in the \code{\link[=Layer]{Layer()}} documentation) or a list thereof (constructed by \code{\link[=list]{list()}} or \code{\link[=c]{c()}}). If given, degree of a node}

\item{levels}{list of layer specifications}
}
\description{
This term adds one network statistic to
the model for each element in \code{d} ; the \eqn{i} th such statistic equals
the number of nodes in the network of out-degree \code{d[i]} , i.e. the
number of nodes with exactly \code{d[i]} out-edges.
}
\details{
This term can only be used with directed networks; for undirected networks
see \code{degree} .

If a list of layer specifications is given, degree of a node
\code{i} is considered to be the number of edges in all layers,
combined.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{frequently-used}
