% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{param_job}
\alias{param_job}
\title{Create An EnergyPlus Parametric Simulation Job}
\usage{
param_job(idf, epw)
}
\arguments{
\item{idf}{A path to EnergyPlus IDF or IMF file or an \code{Idf} object.}

\item{epw}{A path to EnergyPlus EPW file or an \code{Epw} object.}
}
\value{
A \code{ParametricJob} object.
}
\description{
\code{param_job()} takes an IDF and EPW as input and returns a \code{ParametricJob}.
For details on \code{ParametricJob}, please see \link{ParametricJob} class.
}
\examples{
if (is_avail_eplus(8.8)) {
    idf_name <- "1ZoneUncontrolled.idf"
    epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"

    idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
    epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)

    # create from local files
    param_job(idf_path, epw_path)

    # create from an Idf and an Epw object
    param_job(read_idf(idf_path), read_epw(epw_path))
}
}
\seealso{
\code{\link[=eplus_job]{eplus_job()}} for creating an EnergyPlus single simulation job.
}
\author{
Hongyuan Jia
}
