% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{is_eplus_ver}
\alias{is_eplus_ver}
\alias{is_idd_ver}
\alias{is_eplus_path}
\alias{is_idd}
\alias{is_idf}
\alias{is_iddobject}
\alias{is_idfobject}
\alias{is_epw}
\title{Check for Idd, Idf and Epw objects}
\usage{
is_eplus_ver(ver, strict = FALSE)

is_idd_ver(ver, strict = FALSE)

is_eplus_path(path)

is_idd(x)

is_idf(x)

is_iddobject(x)

is_idfobject(x)

is_epw(x)
}
\arguments{
\item{ver}{A character or numeric vector with suitable numeric version
strings.}

\item{strict}{If \code{FALSE}, \code{ver} can be a special string "latest" which
represents the latest version.}

\item{path}{A path to test.}

\item{x}{An object to test.}
}
\value{
A logical vector.
}
\description{
These functions test if input is a valid object of Idd, Idf, Epw and other
main classes.
}
\details{
\code{is_eplus_ver()} returns \code{TRUE} if input is a valid EnergyPlus version.

\code{is_idd_ver()} returns \code{TRUE} if input is a valid EnergyPlus IDD version.

\code{is_eplus_path()} returns \code{TRUE} if input path is a valid EnergyPlus path,
i.e. a path where there is an \code{energyplus} executable and an \code{Energy+.idd}
file.

\code{is_idd()} returns \code{TRUE} if input is an Idd object.

\code{is_idf()} returns \code{TRUE} if input is an Idf object.

\code{is_iddobject()} returns \code{TRUE} if input is an IddObject object.

\code{is_idfobject()} returns \code{TRUE} if input is an IdfObject object.

\code{is_epw()} returns \code{TRUE} if input is an Epw object.
}
\examples{
is_eplus_ver(8.8)
is_eplus_ver(8.0)
is_eplus_ver("latest", strict = FALSE)

is_idd_ver("9.0.1")
is_idd_ver("8.0.1")

is_eplus_path("C:/EnergyPlusV9-0-0")
is_eplus_path("/usr/local/EnergyPlus-9-0-1")

is_idd(use_idd(8.8, download = "auto"))

idf <- read_idf(system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr"),
    idd = use_idd(8.8, download = "auto"))
is_idf(idf)

is_iddobject(idd_object(8.8, "Version"))

is_idfobject(idf_object(idf, 1))

\dontrun{
is_epw(read_epw(download_weather("los angeles.*tmy3", type = "epw", ask = FALSE, max_match = 1)))
}
}
