% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{eplusr_option}
\alias{eplusr_option}
\title{Get and Set eplusr options}
\usage{
eplusr_option(...)
}
\arguments{
\item{...}{Any available options to define, using \code{name = value}. All
available options are shown below. If no options are given, all values of
current options are returned. If a single option name, its value is returned.}
}
\value{
If called directly, a named list of input option values. If input is
a single option name, a length-one vector whose type is determined by
that option. If input is new option values, a named list of newly set
option values.
}
\description{
Get and set eplusr options which affect the way in which eplusr computes and
displays its results.
}
\details{
\itemize{
\item \code{validate_level}: The strictness level of validation during field value
modification and model error checking. Possible value: \code{"none"},
\code{"draft"} and \code{"final"} or a custom validation level using
\code{\link[=custom_validate]{custom_validate()}}. Default: \code{"final"}. For what validation
components each level contains, see \code{\link[=level_checks]{level_checks()}}.
\item \code{view_in_ip}: Whether models should be presented in IP units. Default:
\code{FALSE}. It is not recommended to set this option to \code{TRUE} as currently
IP-units support in eplusr is not fully tested.
\item \code{save_format}: The default format to use when saving Idf objects to \code{.idf} files.
Possible values: \code{"asis"}, \code{"sorted"}, \code{"new_top"} and \code{"new_bot"}.
The later three have the same effect as \verb{Save Options} settings
\code{"Sorted"}, \code{"Original with New at Top"} and \code{"Original with New at Bottom"} in IDF Editor, respectively. For \code{"asis"}, the saving format
will be set according to the header of IDF file. If no header found,
\code{"sorted"} is used. Default: \code{"asis"}.
\item \code{num_parallel}: Maximum number of parallel simulations to run. Default:
\code{parallel::detectCores()}.
\item \code{verbose_info}: Whether to show information messages. Default: \code{TRUE}.
\item \code{autocomplete}: Whether to turn on autocompletion on class and field names.
Underneath, \code{\link[=makeActiveBinding]{makeActiveBinding()}} is used to add or move active bindings in
\link{Idf} and \link{IdfObject}s to directly return objects in class or field values.
This will make it possible to dynamically show current class and field
names in both RStudio and in the terminal. However, this process does have
a penalty on the performance. It can make adding or modifying large mounts
of \link{Idf} and \link{IdfObject}s extremely slower. Default: \code{interactive()}.
}
}
\examples{
# list all current options
eplusr_option() # a named list

# get a specific option value
eplusr_option("verbose_info")

# set options
eplusr_option(verbose_info = TRUE, view_in_ip = FALSE)
}
\author{
Hongyuan Jia
}
