% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idf_object.R
\name{as.character.IdfObject}
\alias{as.character.IdfObject}
\title{Coerce an IdfObject into a Character Vector}
\usage{
\method{as.character}{IdfObject}(x, comment = TRUE, leading = 4L,
  sep_at = 29L, all = FALSE, ...)
}
\arguments{
\item{x}{An \link{IddObject} object.}

\item{comment}{A character vector to be used as comments of returned string
format object. If \code{NULL}, no comments are inserted. Default: \code{NULL}.}

\item{leading}{Leading spaces added to each field. Default: \code{4}.}

\item{sep_at}{The character width to separate value string and field string.
Default: \code{29} which is the same as IDF Editor.}

\item{all}{If \code{TRUE}, all fields in current class are returned, otherwise
only minimum fields are returned.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A character vector.
}
\description{
Coerce an \link{IdfObject} into a character vector in the same way as in IDF Editor.
}
\examples{
\dontrun{
idf <- read_idf(system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr"),
    idd = use_idd(8.8, download = "auto"))

# get the IdfObject of material named "C5 - 4 IN HW CONCRETE"
mat <- idf$Material[["C5 - 4 IN HW CONCRETE"]]

as.character(mat, leading = 0, sep_at = 10)
}
}
