% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{numint}
\alias{numint}
\title{Numerical integration of powers and fractions of powers via simpson rule}
\usage{
numint(time, x, type, A, B)
}
\arguments{
\item{time}{Vector (n) holding time points in between which the integrals are evaluated. Must be one series only (i.e., no decrements).}

\item{x}{Matrix (mx(d+1)) holding discretised function. First column is time, must have no decrements. The remaining columns are function values, which will be interpolated.}

\item{type}{String telling type, must be "power" or "fracpower".}

\item{A}{Matrix (pxd) holding powers in rows.}

\item{B}{Matrix (pxd) holding powers in rows.}
}
\value{
A matrix of dimension (m-1)xp holding the row-concatinated blocks of integrals:
If \code{type} is "power" it evaluates the numerical integrals
\deqn{(\int^{t_{i+1}}_{t_i}{x(s)^A})_i}
where t_i are entries in first column of \code{x} and \eqn{x(s)} is constructed via a linear interpolation of \code{x}.
If \code{type} is "fracpower" it evaluates the numerical integrals
\deqn{(\int^{t_{i+1}}_{t_i}{x(s)^A / (1 + x(s)^B)})_i}
where the fraction is evaluated coordinate wise.

The numerical integration uses the simpson rule using the intermediate time points in \code{time} in between any two consecutive time points in the first column of \code{x}.
To get more accurate integrals include more intermediate time points in \code{time}.
}
\description{
Evaluates numerical integrals of powers or fractions of powers of a d-dimensional function x.
}
\examples{
# Trajectory of power law kinetics system
A <- matrix(c(1, 0, 1,
              1, 1, 0), byrow = TRUE, nrow = 2)
p <- plk(A)
x0 <- c(10, 4, 1)
theta <- matrix(c(0, -0.25,
                  0.75, 0,
                  0, -0.1), byrow = TRUE, nrow = 3)
Time <- seq(0, 1, by = .025)
traj <- numsolve(p, Time, x0, theta)

# Example: Integrate traj(s)^A between the time points in 'ti'
ti <- seq(0, 1, by = .1)
ss <- numint(time = ti, x = traj, type = "power", A = A, B = A)

# Example: Integrate traj(s)^A / (1 + traj(s)^B) between the time points in 'ti'
B <- matrix(c(0, 2, 1,
              2, 1, 0), byrow = TRUE, nrow = 2)
ss <- numint(time = ti, x = traj, type = "fracpower", A = A, B = B)

}
\seealso{
imd, aim
}
