% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_epiflows.R
\name{map_epiflows}
\alias{map_epiflows}
\title{Map flows of people between locations}
\usage{
map_epiflows(
  x,
  title = "",
  center = NULL,
  sort = TRUE,
  pal = "YlOrBr",
  adjust_width = TRUE,
  ...
)
}
\arguments{
\item{x}{An \code{epiflows} object.}

\item{title}{Plot title.}

\item{center}{An optional set of coordinates or character string specifying ID to use as the center of the map}

\item{sort}{a logical. When \code{TRUE} (default), the flows will be sorted
in order of number of cases on the map so that the largest flows appear on
top.}

\item{pal}{a color palette to pass on to \code{\link[leaflet:colorNumeric]{leaflet::colorQuantile()}}. This
can be the name of a viridis or RColorBrewer palette, a vector of hex colors,
or a color-generating functon.}

\item{adjust_width}{a logical specifying if the width of the flows should
be adjusted to reflect the number of flows between locations. Defaults to
\code{TRUE}.}

\item{...}{Additional parameters (not used).}
}
\value{
A \code{leaflet} object
}
\description{
The function \code{map_epiflows} uses \code{leaflet} to generate an interactive map
displaying flows of people travelling between locations stored in a
\code{epiflows} object. Note that the object needs to possess geographic
coordinates.
}
\examples{
data("Brazil_epiflows")
data("YF_coordinates")
ef <- add_coordinates(Brazil_epiflows, YF_coordinates[-1])
plot(ef)
map_epiflows(ef, center = "Espirito Santo", title = "Flows to and from Brazil")
}
\author{
Paula Moraga, Pawel Piatkowski, Salla Toikkanen, Zhian Kamvar
}
