% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeVariable.R
\name{removeVariable}
\alias{removeVariable}
\title{Remove variables containing NaNs or NAs from data.frames.}
\usage{
removeVariable(data = NULL, string = NA, na.prop = 1, nan.prop = 1)
}
\arguments{
\item{data}{a data.frame from which variables are removed.}

\item{string}{a flag character specifying variables to be removed.}

\item{na.prop}{a numeric value specifying NA threshold proportion for removing variables. The default threashold is 1.0, meaning that variables including only NAs are removed.}

\item{nan.prop}{a numeric value specifying NaN threshold proportion for removing variables. The default threashold is 1.0, meaning that variables including only NaNs are removed.}
}
\value{
a data.frame from which some variables are removed.
}
\description{
In reading data, incomplete variables are sometimes included, and only NAs or NaNs are included in some variables.
This function removes such variables in the data.frame. In addition to NAs or NaNs, variables which contain specified keyword can also be removed.
}
\examples{
df <- data.frame(imcomp=rep(NA, 10), imcomp2=rep(NaN, 10), cov1=rnorm(10), NO_USE=rnorm(10))
df2 <- removeVariable(df, string="NO_USE")
str(df)
str(df2)
}

