% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertNA.R
\name{convertNA}
\alias{convertNA}
\title{Convert a character pattern into NA in character and vice versa.}
\usage{
convertNA(data = NULL, na.character = c("", "."), reverse = FALSE)
}
\arguments{
\item{data}{a data.frame to summarize.}

\item{na.character}{a character vector specifying missing character.}

\item{reverse}{a logical value specifying reverse replacement that NA is replaced with the first element of na.character.}
}
\value{
a data.frame with NA replacement.
}
\description{
Convert a character pattern into NA in character and vice versa.
}
\examples{
dat <- data.frame(a=c("","2","3"),b=c("4", NA, "."), stringsAsFactors=FALSE)
dat2 <- convertNA(dat)
dat3 <- convertNA(dat2, na.character=".", reverse=TRUE)
dat
dat2
dat3
}
\seealso{
\code{\link{countNA}}
}

