% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractVariable.R
\name{extractVariable}
\alias{extractVariable}
\title{Extract variables according to mode from data.frame.}
\usage{
extractVariable(data = NULL, mode = "numeric")
}
\arguments{
\item{data}{a data.frame from which numeric variables are extracted.}

\item{mode}{a character specifying object type. Object modes of \sQuote{numeric}, \sQuote{character}, \sQuote{factor}, and \sQuote{logical} are supported.}
}
\value{
a data.frame which includes only specified mode of variables.
}
\description{
This function extract variables which match specified mode from data.frame, and make a new data frame.
}
\examples{
df <- data.frame(id=seq(1,10), str=letters[1:10], fac=factor(seq(1,10)), stringsAsFactors=FALSE)
extractVariable(df)
extractVariable(df, mode="character")
extractVariable(df, mode="factor")
}

