% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{sim_phenotype}
\alias{sim_phenotype}
\title{Simulates a binary phenotype}
\usage{
sim_phenotype(X, causal, model, intercept = TRUE)
}
\arguments{
\item{X}{genotype matrix}

\item{causal}{causal SNPs.}

\item{model}{disease model}

\item{intercept}{binary flag. If \code{intercept=TRUE}, a non-null intercept
is added so that the output is (approximately) balanced between cases and
controls.}
}
\value{
A vector of simulated phenotypes which are encoded as a two-level
  factor (TRUE/FALSE).
}
\description{
The phenotypes are simulated according to a logistic regression model.
Depending on the chosen configuration in \code{\link{sample_SNP}}, the model
includes different effect types: synergistic effects with the target,
marginal effects and additional epistatic effects. We offer the option to
generate a balanced phenotype vector between cases and controls, through the
\code{intercept} parameter.
}
\examples{
nX <- 5
nY <- 3
nZ12 <- 2
clusters <- rep(seq_len(25), each = 3)
names(clusters) <- paste0("SNP_", seq_along(clusters))
MAF <- runif(length(clusters), min = 0.2, max = 0.5)

n_samples <- 3
X <- matrix((runif(n_samples * length(clusters)) < 0.4) +
            (runif(n_samples * length(clusters)) < 0.4),
            ncol = length(clusters), nrow = n_samples)

colnames(X) <- names(clusters)

causal <- sample_SNP(
 nX, nY, nZ12, clusters, MAF, thresh_MAF = 0.2, window_size = 2,
 overlap_inter = 0)
model <- gen_model(nX, nY, nZ12, mean = rnorm(4), sd = rep(1, 4))
Y <- sim_phenotype(X, causal, model, intercept = TRUE)

}
\seealso{
\code{\link{sample_SNP}} and \code{\link{gen_model}}
}
