% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.r
\name{ENgetlinktype}
\alias{ENgetlinktype}
\title{Retrieve the type code for a link}
\usage{
ENgetlinktype(linkindex)
}
\arguments{
\item{linkindex}{for which type code is requested}
}
\value{
integer type-code of the link
}
\description{
Retrieve the type code for a link
}
\note{
Link indexes are consecutive integers starting from 1. Link type codes
  consist of the following constants:
  \tabular{lll}{
  \code{EN_CVPIPE} \tab 0 \tab Pipe with Check Valve\cr
  \code{EN_PIPE}	  \tab 1 \tab Pipe\cr
  \code{EN_PUMP}	  \tab 2 \tab Pump\cr
  \code{EN_PRV}	  \tab 3 \tab Pressure Reducing Valve\cr
  \code{EN_PSV}	  \tab 4 \tab Pressure Sustaining Valve\cr
  \code{EN_PBV}	  \tab 5 \tab Pressure Breaker Valve\cr
  \code{EN_FCV}	  \tab 6 \tab Flow Control Valve\cr
  \code{EN_TCV}	  \tab 7 \tab Throttle Control Valve\cr
  \code{EN_GPV}	  \tab 8 \tab General Purpose Valve\cr
  }
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetlinktype(1)
ENgetlinktype(12)
ENclose()
}
\seealso{
\code{\link{ENgetlinkindex}}
}
