% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.r
\name{ENsetnodevalue}
\alias{ENsetnodevalue}
\title{Set the parameter value for a node.}
\usage{
ENsetnodevalue(index, paramcode = NULL, value = NULL)
}
\arguments{
\item{index}{An integer vector, the node index.}

\item{paramcode}{An integer vector, the parameter code (see Details below).}

\item{value}{A numeric vector, the new value of the parameter.}
}
\value{
returns NULL invisibly on success or raises an error or warning.
}
\description{
\code{ENsetnodevalue} sets parameter value for one node.
}
\details{
Nodes are indexed starting from 1 in the order in which they were entered into the
  \code{[NODES]} section of the EPANET input file.
  
  Node parameter codes consist of the following constants:
  \tabular{lrl}{
  \code{EN_ELEVATION}  \tab 0  \tab Elevation\cr
  \code{EN_BASEDEMAND} \tab 1  \tab Base demand\cr
  \code{EN_PATTERN}    \tab 2  \tab Demand pattern index\cr
  \code{EN_EMITTER}    \tab 3  \tab Emitter coeff.\cr
  \code{EN_INITQUAL}   \tab 4  \tab Initial quality\cr
  \code{EN_SOURCEQUAL} \tab 5  \tab Source quality\cr
  \code{EN_SOURCEPAT}  \tab 6  \tab Source pattern index\cr
  \code{EN_SOURCETYPE} \tab 7  \tab Source type (see note below)\cr
  \code{EN_TANKLEVEL}  \tab 8  \tab Initial water level in tank\cr
  }

  Source types are identified with the following constants:
  \tabular{ll}{
   \code{EN_CONCEN}    \tab 0\cr
   \code{EN_MASS}      \tab 1\cr
   \code{EN_SETPOINT}  \tab 2\cr
   \code{EN_FLOWPACED} \tab 3
  }

  See \code{[SOURCES]} for a description of these source types.
 
  Values are supplied in units which depend on the units used for flow rate in the EPANET
  input file (see Units of Measurement).
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetnodevalue(3, "EN_ELEVATION")
ENsetnodevalue(3, "EN_ELEVATION", 777)
ENgetnodevalue(3, "EN_ELEVATION")
ENclose()
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___network_info.html}
}
