% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/evepan.R
\name{evepan}
\alias{evepan}
\title{Calculate expected value}
\usage{
evepan(c = 0, mu = 0, r = 5^0.5)
}
\arguments{
\item{c}{censoring point.}

\item{mu}{mean of distribution prior to censoring.}

\item{r}{half the range of the distribution, ie the distance from the mean to the smallest/largest value supported by the distribution. \code{r=5^.5} correspons to a standard deviation of 1.}
}
\value{
the expected value associated with \code{c}, \code{mu} and \code{r}.
}
\description{
This function calculates the expected value of a random left-censored epanechnikov-distributed variable with a given censoring point.
The inverse of this function is \code{cepan}.
}
\examples{
evepan(c=100,mu=100,r=10) #Expected value of an epan-distributed variable left-censored at 100
}
\keyword{distribution}

