\name{writePeaklist}
\alias{writePeaklist}

\title{
Export a .csv peak table from an MSlist object
}

\description{
Given an MSlist object containing peak picking results from \code{\link[enviPick]{mzpick}}, export a peak table.csv.
}

\usage{
writePeaklist(MSlist, directory, filename, overwrite = FALSE)
}

\arguments{

	\item{MSlist}{A MSlist object generated by \code{\link[enviPick]{enviPickwrap}} or \code{\link[enviPick]{mzpick}}}
	\item{directory}{Character string with the directory to write to}
	\item{filename}{Name of the .csv file to create}
	\item{overwrite}{TRUE/FALSE}
}

\value{
.csv table, with columns:

		m/z (mean m/z of peak measurements), 
		var_m/z (m/z variation of peak measurements),
		max_int (base-line corrected maximum intensity),
		sum_int (sum of all base-line corrected peak measurement intensities),
		RT (retention time at maximum intensity),
		minRT (start peak RT),
		maxRT (end peak RT),
		peak# (peak ID number),
		EIC# (EIC ID number),
		Score (not yet implemented)

}

\author{Martin Loos}
