% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-autoproc_annots.R
\name{duplicate_level}
\alias{duplicate_level}
\title{Duplicate level}
\usage{
duplicate_level(emuDBhandle, levelName, duplicateLevelName,
  duplicateLinks = TRUE, linkDuplicates = FALSE,
  linkDefType = "ONE_TO_ONE", verbose = TRUE)
}
\arguments{
\item{emuDBhandle}{emuDB handle object (see \link{load_emuDB})}

\item{levelName}{name of level in emuDB that is to be duplicated}

\item{duplicateLevelName}{name given to newly duplicated level}

\item{duplicateLinks}{if set to \code{TRUE} (the default) all the
links to and from the original items are duplicated to point to the 
new items of the new duplicate level.}

\item{linkDuplicates}{link the duplicated ITEMs to the originals. This
can only be set to \code{TRUE} if \code{duplicateLinks} is set to \code{FALSE}.}

\item{linkDefType}{type given to link definition. Only relevant if \code{linkDuplicates}
is set to \code{TRUE}.}

\item{verbose}{show progress bars and further information}
}
\description{
Duplicate level of emuDB including all of its items and its various 
attributeDefinitions. If the \code{duplicateLinks} variable is set 
to \code{TRUE} all the links to and from the original items are 
duplicated.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# duplicate Phonetic level
duplicate_level(ae, levelName = "Phonetic",
                    duplicateLevelName = "Phonetic2")

}

}
\seealso{
\code{\link{load_emuDB}}
}
\keyword{emuDB}
