% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{fiber}
\alias{fiber}
\title{Fiber data}
\format{A data frame with 15 observations and 3 variables:
\describe{
  \item{\code{machine}}{a factor with levels \code{A} \code{B} \code{C}. 
    This is the primary factor of interest.}
  \item{\code{strength}}{a numeric vector. The response variable.}
  \item{\code{diameter}}{a numeric vector. A covariate.}
}}
\source{
Montgomery, D. C. (2013) \emph{Design and Analysis of Experiments}
  (8th ed.). John Wiley and Sons, ISBN 978-1-118-14692-7.
}
\usage{
fiber
}
\description{
Fiber data from Montgomery Design (8th ed.), p.656 (Table 15.10). Useful as a
simple analysis-of-covariance example.
}
\details{
The goal of the experiment is to compare the mean breaking strength of fibers
produced by the three machines. When testing this, the technician also
measured the diameter of each fiber, and this measurement may be used as a
concomitant variable to improve precision of the estimates.
}
\examples{
fiber.lm <- lm(strength ~ diameter + machine, data=fiber)
ref_grid(fiber.lm)

# Covariate-adjusted means and comparisons
emmeans(fiber.lm, pairwise ~ machine)

}
\keyword{datasets}
