% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.r
\name{impute}
\alias{impute}
\alias{impute_knn}
\alias{impute_median}
\title{Regular imputation}
\usage{
impute_knn(x, k = 0.05, distance_matrix = "auto")

impute_median(x)
}
\arguments{
\item{x}{Dataset.}

\item{k}{Number of nearest neighbors to use.}

\item{distance_matrix}{Distance matrix.}
}
\value{
An imputed matrix.
}
\description{
If you want to impute, build model and predict you should use
\code{\link{pre_impute_median}} or \code{\link{pre_impute_knn}}.
This function imputes using all observations
without caring about cross-validation folds.
}
\details{
For additional information on the parameters see \code{\link{pre_impute_knn}}
and \code{\link{pre_impute}}.
}
\examples{
x <- matrix(rnorm(36), 6, 6)
x[sample(length(x), 5)] <- NA
impute_knn(x)
impute_median(x)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{pre_process}},
  \code{\link{pre_impute_knn}}, \code{\link{pre_impute_median}}
}

