% Generated by roxygen2 (4.0.1): do not edit by hand
\name{emil.fit.glmnet}
\alias{emil.fit.glmnet}
\title{Fit GLM with LASSO, Ridge or elastic net regularization.}
\usage{
emil.fit.glmnet(x, y, family, nfolds, foldid, alpha = 1, lambda = NULL, ...)
}
\arguments{
\item{x}{Dataset.}

\item{y}{Response vector. Can be of many different types for solving
different problems, see \code{\link[glmnet]{glmnet}}.}

\item{family}{Determines the the type of problem to solve. Auto detected if
\code{y} is numeric or survival. See \code{\link{family}} for details.}

\item{nfolds}{See \code{\link[glmnet]{cv.glmnet}}.}

\item{foldid}{See \code{\link[glmnet]{cv.glmnet}}.}

\item{alpha}{Regularization parameter, see \code{\link[glmnet]{glmnet}}.}

\item{lambda}{Regularization parameter, see \code{\link[glmnet]{glmnet}}.}

\item{...}{Sent to \code{\link[glmnet]{cv.glmnet}}.}
}
\value{
Fitted GLM.
}
\description{
Fits generalized linear models with regularization using the \code{glmnet}
package implementation.
}
\details{
The \code{alpha} parameter of \code{\link[glmnet]{glmnet}} controls the type of
penalty. Use \code{0} (default) for lasso only, \code{1} for ridge only, or
an intermediate for a combination. This is typically the variable to tune
on. The shrinkage, controlled by the \code{lambda} parameter, can be left
unspecified for internal tuning (works the same way as
\code{\link{emil.fit.glmnet}}).
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{emil.predict.glmnet}},
  \code{\link{modeling.procedure}}
}

