% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tsd.R
\name{plot.tsd}
\alias{plot.tsd}
\title{Plot results of tsd() that best describe temperature-dependent sex determination}
\usage{
\method{plot}{tsd}(x, ..., show.observations = TRUE, males.freq = TRUE,
  las.x = 1, las.y = 1, lab.PT = paste("Pivotal ", x$type),
  resultmcmc = NULL, chain = 1, l = 0.05, replicate.CI = 10000,
  range.CI = 0.95, mar = c(4, 4, 4, 1) + 0.4, temperatures.plot = seq(from
  = 25, to = 35, by = 0.1), durations.plot = seq(from = 40, to = 70, by =
  0.1), lab.TRT = paste0("Transitional range of ", x$type, "s l=", x$l * 100,
  "\%"), col.TRT = "gray", col.TRT.CI = rgb(0.8, 0.8, 0.8, 0.5),
  col.PT.CI = rgb(0.8, 0.8, 0.8, 0.5), show.CI = TRUE)
}
\arguments{
\item{x}{A result file generated by tsd()}

\item{...}{Parameters for plot()}

\item{show.observations}{Should the observations be shown}

\item{males.freq}{Should the graph uses males relative frequency [TRUE] or females [FALSE]}

\item{las.x}{las parameter for x axis}

\item{las.y}{las parameter for y axis}

\item{lab.PT}{Label to describe pivotal temperature}

\item{resultmcmc}{A result of tsd_MHmcmc()}

\item{chain}{What chain to be used is resultmcmc is provided}

\item{l}{Sex ratio limits to define TRT are l and 1-l}

\item{replicate.CI}{replicate.CI replicates from the hessian matrix to estimate CI}

\item{range.CI}{The range of confidence interval for estimation, default=0.95}

\item{mar}{The par("mar") parameter}

\item{temperatures.plot}{Temperatures used for showing curves of sex ratio}

\item{durations.plot}{Durations used for showing curves of sex ratio}

\item{lab.TRT}{Label to describe transitional range of temperature}

\item{col.TRT}{The color of TRT}

\item{col.TRT.CI}{The color of CI of TRT based on range.CI}

\item{col.PT.CI}{The color of CI of PT based on range.CI}

\item{show.CI}{Do the CI for the curve should be shown}
}
\value{
Nothing
}
\description{
Plot the estimates that best describe temperature-dependent sex determination.
}
\details{
plot.tsd plot result of tsd() that best describe temperature-dependent sex determination
}
\examples{
\dontrun{
CC_AtlanticSW <- subset(DatabaseTSD, RMU=="Atlantic, SW" & 
                          Species=="Caretta caretta" & (!is.na(Sexed) & Sexed!=0))
tsdL <- with (CC_AtlanticSW, tsd(males=Males, females=Females, 
                                 temperatures=Incubation.temperature-Correction.factor, 
                                 equation="logistic"))
plot(tsdL)
}
}
\references{
Girondot, M. 1999. Statistical description of temperature-dependent sex determination using maximum likelihood. Evolutionary Ecology Research, 1, 479-486.

Godfrey, M.H., Delmas, V., Girondot, M., 2003. Assessment of patterns of temperature-dependent sex determination using maximum likelihood model selection. Ecoscience 10, 265-272.

Hulin, V., Delmas, V., Girondot, M., Godfrey, M.H., Guillon, J.-M., 2009. Temperature-dependent sex determination and global change: are some species at greater risk? Oecologia 160, 493-506.

Girondot M., Submited. On the concept of embryological thermosensitive period for sex determination in reptiles.
}
\author{
Marc Girondot
}
