% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.NestsResult.R
\name{plot.NestsResult}
\alias{plot.NestsResult}
\title{Plot the information about a nest}
\usage{
\method{plot}{NestsResult}(x, ..., OutPlot = NULL, parameters = NULL,
  SexualisationTRN = NULL, fixed.parameters = NULL, SE = NULL,
  temperatures = NULL, derivate = NULL, test = NULL, stopattest = FALSE,
  M0 = NULL, series = 1, col.stages = "blue", col.PT = "red",
  col.TSP = "gray", col.temperatures = "green", col.S = "black",
  lty.temperatures = 1, lwd.temperatures = 2, ylimT = c(25, 35),
  ylimS = NULL, xlim = NULL, TSP.borders = c(21, 26),
  embryo.stages = "Caretta caretta", show.stages = TRUE, show.TSP = TRUE,
  show.third = TRUE, show.CI = TRUE, replicate.CI = 100,
  ref.stage = TRUE, show.fioritures = TRUE, progress = TRUE,
  show.temperatures = TRUE, show.PT = TRUE, PT = c(NA, NA),
  show.test = TRUE, lab.third = "2nd third of incubation",
  at.lab.third = 4, lab.PT = "PT", lab.stages = "Stages", mar = c(4, 5,
  4, 5) + 0.3, xlab = "Days of incubation",
  ylabT = expression("Temperatures in " * degree * "C"),
  ylabS = "Embryo metric", show.plot = TRUE)
}
\arguments{
\item{x}{A result file generated by searchR}

\item{...}{Parameters for plot()}

\item{OutPlot}{A previous output of a plot.NestsResult() or info.nests()}

\item{parameters}{A set of parameters if result is not provided.}

\item{SexualisationTRN}{A set of parameters used to model thermal reaction norm during TSP}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if result is not provided.}

\item{temperatures}{Timeseries of temperatures. Will replace the one in result.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings ie test=c(Mean=xx, SD=yy)}

\item{stopattest}{True or False, does the plot stops when proxi of size reaches the mean test size.}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{series}{The name or number of the series to be displayed. Only one series can be displayed at a time.}

\item{col.stages}{The color of the stages}

\item{col.PT}{The color of the pivotal temperature}

\item{col.TSP}{The color of the TSP}

\item{col.temperatures}{The color of the temperatures}

\item{col.S}{The color of the size or mass. Can be a vector (useful when series="all" option).}

\item{lty.temperatures}{Type of line for temperatures}

\item{lwd.temperatures}{Width of line for temperatures}

\item{ylimT}{Range of temperatures to be displayed}

\item{ylimS}{Range of size to be displayed}

\item{xlim}{Range of incubation days to be displayed}

\item{TSP.borders}{The limits of TSP}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided if show.TSP is TRUE}

\item{show.stages}{True or False, does the embryo stages should be displayed}

\item{show.TSP}{True or False, does the TSP boders should be displayed}

\item{show.third}{True or False, does the first and second third boders should be displayed}

\item{show.CI}{True or False, do the confidence intervals should be displayed}

\item{replicate.CI}{Number of randomizations to estimate CI}

\item{ref.stage}{If TRUE, the reference size for stage is the observed one in modelling. If FALSE, it is the field observed size.}

\item{show.fioritures}{If FALSE, set show.PT, show.temperatures, show.stages, show.TSP, show.third, show.CI to FALSE}

\item{progress}{If FALSE, the progress bar is not shown (useful for use with sweave or knitr)}

\item{show.temperatures}{True or False, does the temperatures should be displayed}

\item{show.PT}{TRUE or FALSE, does the pivotal temperature should be displayed}

\item{PT}{Value for pivotal temperature}

\item{show.test}{True or False, does the hatchling size should be displayed}

\item{lab.third}{Label for 2nd third of incubation}

\item{at.lab.third}{Position of Label for 2nd third of incubation [default=4]}

\item{lab.PT}{Label for Pivotal Temperature}

\item{lab.stages}{Label for Stages}

\item{mar}{Parameter mar used for plot}

\item{xlab}{Label for axis}

\item{ylabT}{Label for temperature axis}

\item{ylabS}{Label for size axis}

\item{show.plot}{If FALSE, only the text output is shown}
}
\value{
A list with informations about statistics for the series of nests analyzed ($summary) and exact times series of length changes for each nest ($traces)
}
\description{
Plot the information about a nest\cr
The embryo.stages is a list with stage numbers and relative size as compared to final size at the beginning of the stage.\cr
For example for Caretta caretta, embryo.stages=list(number=21:30, size=c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33) indicates that the stages 21 begins at the relative size of 8.4/39.33.\cr
The default is for the turtle "Caretta caretta".\cr
Series can be indicated as the name of the series, its number or succesion of TRUE or FALSE. "all" indicates that all series must be printed.\cr
}
\details{
plot.NestsResult Plot the information about a nest
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
plot(resultNest_4p, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45), series=1,
	SE=c(DHA=1.396525, DHH=4.101217, T12H=0.04330405, Rho25=1.00479))
# to plot all the nest at the same time, use
plot(resultNest_4p, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45),
	series="all", show.fioritures=FALSE)
# to use color different for series
plot(resultNest_4p, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45),
	series="all", show.fioritures=FALSE, col.S=c(rep("black", 5), rep("red", 6)))
}
}
\author{
Marc Girondot
}

