% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.panelmodel.R
\name{em.panelmodel}
\alias{em.panelmodel}
\title{The em function for `panelmodel` such as `plm`.}
\usage{
\method{em}{panelmodel}(
  object,
  latent = 2,
  verbose = FALSE,
  init.method = c("random", "kmeans"),
  algo = c("em", "cem", "sem"),
  max_iter = 500,
  concomitant = list(...),
  ...
)
}
\arguments{
\item{object}{the model used, e.g. `lm`, `glm`, `gnm`, `plm`.}

\item{latent}{the number of latent classes.}

\item{verbose}{`True` to print the process of convergence.}

\item{init.method}{the initialization method used in the model.
The default method is `random`.}

\item{algo}{the algorithm used in em: the default EM algorithm,
the classification em `cem`, or the stochastic em `sem`.}

\item{max_iter}{the maximum iteration for em algorithm.}

\item{concomitant}{the formula to define the concomitant part of the model.
The default is NULL.}

\item{...}{arguments used in the `model`.}
}
\value{
An object of class `em` is a list containing at least the following components:
 \code{models} a list of models/objects whose class are determined by a model fitting from the previous step.  
 \code{pi} the prior probabilities.
 \code{latent} number of the latent classes.
 \code{algorithm} the algorithm used (could be either `em`, `sem` or `cem`).
 \code{obs} the number of observations.
 \code{post_pr} the posterior probabilities.
 \code{concomitant} a list of the concomitant model. It is empty if no concomitant model is used.
 \code{init.method} the initialization method used.
 \code{call} the matched call.
 \code{terms} the code{terms} object used.
}
\description{
The em function for `panelmodel` such as `plm`.
}
