% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_shards.R
\name{search_shards}
\alias{search_shards}
\title{Search shards.}
\usage{
search_shards(index = NULL, raw = FALSE, routing = NULL,
  preference = NULL, local = NULL, ...)
}
\arguments{
\item{index}{One or more indeces}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If \code{FALSE}, then
raw JSON}

\item{routing}{A character vector of routing values to take into account
when determining which shards a request would be executed against.}

\item{preference}{Controls a preference of which shard replicas to execute
the search request on. By default, the operation is randomized between the
shard replicas. See \link{preference} for a list of all acceptable
values.}

\item{local}{(logical) Whether to read the cluster state locally in order
to determine where shards are allocated instead of using the Master node's
cluster state.}

\item{...}{Curl args passed on to \code{\link[httr:GET]{httr::GET()}}}
}
\description{
Search shards.
}
\examples{
\dontrun{
search_shards(index = "plos")
search_shards(index = c("plos","gbif"))
search_shards(index = "plos", preference='_primary')
search_shards(index = "plos", preference='_shards:2')

library('httr')
search_shards(index = "plos", config=verbose())
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/search-shards.html}
}
