% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\title{Validate a search}
\usage{
validate(index, type = NULL, ...)
}
\arguments{
\item{index}{Index name. Required.}

\item{type}{Document type. Optional.}

\item{...}{Additional args passed on to \code{\link{Search}}}
}
\description{
Validate a search
}
\examples{
\dontrun{
if (!index_exists("twitter")) index_create("twitter")
docs_create('twitter', type='tweet', id=1, body = list(
   "user" = "foobar", 
   "post_date" = "2014-01-03",
   "message" = "trying out Elasticsearch"
 )
)
validate("twitter", q='user:foobar')
validate("twitter", "tweet", q='user:foobar')

body <- '{
"query" : {
  "bool" : {
    "must" : {
      "query_string" : {
        "query" : "*:*"
      }
    },
    "filter" : {
      "term" : { "user" : "kimchy" }
    }
  }
}
}'
validate("twitter", body = body)
}
}
\seealso{
\code{\link{Search}}
}

