\name{runMBayes}
\alias{runMBayes}
\title{Metropolis Algorithm for ecological Inference}
\usage{
runMBayes(convList, whichPriori = "gamma", prioriPars = list(shape = 4, rate
  = 2), startValsAlpha = NULL, startValsBeta = NULL, betaVars = NULL,
  alphaVars = NULL, sample, burnin = 0, thinning = 1, verbose = 1,
  retBeta = FALSE, seed = NULL)
}
\arguments{
  \item{convList}{output of
  \code{\link{convertEiData}}-function.}

  \item{whichPriori}{character string specifying the chosen
  hyperpriori.  Options are \code{"gamma"} or \code{"expo"}
  (see Details)}

  \item{prioriPars}{vector or matrix of parameters for the
  specified hyperpriori in \var{whichPriori}}

  \item{startValsAlpha}{matrix with dimension
  \code{c(rows,columns)} giving the starting values for
  alpha.  If \code{NULL} random numbers of rdirichlet with
  chosen hyperpriori will be chosen.}

  \item{startValsBeta}{array with dimension
  \code{c(rows,columns,districts)} giving the starting
  values of beta If \code{NULL} random multinomial numbers
  will be chosen.}

  \item{sample}{the sample size to be saved in output.
  Total length of chain will be \var{burnin} \code{+}
  \var{sample} \code{*} \var{thinning}}

  \item{burnin}{number of draws to be cut away from the
  beginning of the Markov-Chain. \code{default=0}}

  \item{thinning}{number specifying the thinning interval.
  \code{default=1}}

  \item{verbose}{an integer specifying whether the progress
  of the sampler is printed to the screen (defaults to 0).
  If verbose is greater than 0, the iteration number is
  printed to the screen every verboseth iteration}

  \item{betaVars}{array-object with dimensions \code{(rows,
  columns-1, districts)} giving variance of proposal
  density for \eqn{\beta}-values}

  \item{alphaVars}{matrix of dimensions \code{(rows,
  columns)} giving variance of proposal density for
  \eqn{\alpha}-values.}

  \item{retBeta}{logical \code{TRUE} if estimated
  \eqn{\beta}-parameters should be returned.  With large
  number of precincts there can be problems with memory}

  \item{seed}{Default is \code{NULL}. Can be given the
  \code{"seed"}-attribute of an \code{eiwild}-object to
  reproduce an \code{eiwild}-object}
}
\value{
\code{list}-Object with elements: \itemize{ \item
\code{alphaDraws} \code{\link[coda]{mcmc}}-object \item
\code{cellCounts} \code{\link[coda]{mcmc}}-object \item
\code{betaDraws} \code{\link[coda]{mcmc}}-object \item
\code{betaAcc} \code{"numeric"} with Acceptance ratios
\item \code{alphaAcc} \code{"numeric"} with Acceptance
ratios \item \code{alphaVars} \code{matrix} with variances
for proposal density \item \code{betaVars} \code{array}
with variances for proposal density }
}
\description{
This function is a wrapper function which calls the
appropriate Metropolis algorithm depending on the
hyperpriori which is chosen.
}
\details{
The \code{whichPriori}-parameter has the options
\code{"gamma"} or \code{"expo"} and corresponding
\code{prioriPars}-parameters in a \code{"list"}: \itemize{
\item \code{"expo"} and \code{numeric} list-element called
\code{"lam"} corresponding to: \eqn{\alpha_{rc} \sim
Exp(\lambda)} \item \code{"expo"} and \code{matrix}
list-element called \code{"lam"} corresponding to:
\eqn{\alpha_{rc} \sim Exp(\lambda_{rc})} \item
\code{"gamma"} and two \code{numeric} list-element called
\code{"shape"} and \code{"rate"} corresponding to:
\eqn{\alpha_{rc} \sim Gamma(\lambda_1, \lambda_2)} \item
\code{"gamma"} and two \code{matrix} list-element called
\code{"shape"} and \code{"rate"} corresponding to:
\eqn{\alpha_{rc} \sim Gamma(\lambda_1^{rc},
\lambda_2^{rc})} }

The \code{"seed"} attribute is generated by the
\code{\link{.Random.seed}}-function.
}
\examples{
\dontrun{
# loading some fake election data
data(topleveldat)
form <- cbind(CSU_2, SPD_2, LINK_2, GRUN_2) ~ cbind(CSU_1, SPD_1, Link_1)
conv <- convertEiData(form=form, aggr=aggr, indi=indi, IDCols=c("ID","ID"))
set.seed(1234)
res <- runMBayes(conv, sample=1000, thinning=2, burnin=100,verbose=100)

## !!! not an eiwild object !!!
class(res)

# better to use indAggEi
set.seed(12345)
res2 <- indAggEi(form=form, aggr=aggr, indi=indi, IDCols=c("ID","ID"),
                 sample=1000, thinning=2, burnin=100,verbose=100)
class(res2)
summary(res2)

# with individual alpha-hyperpriori-parameters
hypMat <- list(shape = matrix(c(30,4,4,4,
                                4,30,4,4,
                                4,4,30,4), nrow=3, ncol=4, byrow=TRUE),
               rate = matrix(c(1,2,2,2,
                               2,1,2,2,
                               2,2,1,2), nrow=3, ncol=4, byrow=TRUE))
set.seed(12345)
res2 <- indAggEi(form=form, aggr=aggr, indi=indi, IDCols=c("ID","ID"),
                 sample=1000, thinning=2, burnin=100, verbose=100,
                 prioriPars=hypMat, whichPriori="gamma")
}
}
\seealso{
\code{\link[eiwild]{convertEiData}},
\code{\link[eiwild]{runMBayes}}, \code{\link[coda]{mcmc}}
\code{\link[eiwild]{tuneVars}},
\code{\link[eiwild]{indAggEi}}
}

