% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.egonet.R
\name{wide.to.long}
\alias{wide.to.long}
\title{Transform 'wide' alter-level data to the 'long'-format}
\usage{
wide.to.long(
  wide,
  egoID = "egoID",
  max.alters,
  start.col,
  end.col,
  var.wise = FALSE
)
}
\arguments{
\item{wide}{A \code{data.frame} of alter attributes in the wide format.}

\item{egoID}{\code{Character}. Name of the variable identifying egos (default: "egoID").}

\item{max.alters}{A \code{numeric} giving the maximum number of alters.}

\item{start.col}{Index or name of the first colum containg alter-alter relation data.
#!# Should: Defaults to first column of \code{wide}.}

\item{var.wise}{a logical value indicating wheter the alter attributes are
stored variable-wise, if FALSE alter-wise storage is assumed.}

\item{last.col}{Index or name of the first colum containg alter-alter relation data.
#!# Should: Defaults to last column of \code{wide}.}

\item{ego.vars}{A \code{data.frame} of alter attributes in the wide format.}
}
\description{
A function to transform a wide-format dataframe of ego-centered network data
into a long-format data-frame, where every row represents one alter/dyad. In
the created dataframe numerous networks can be distinguished by a network ID
(egoID).
}
\keyword{internal}
